package com.digiwin.athena.base.infrastructure.mapper.audc.userdefined;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.base.infrastructure.meta.po.userdefined.UserOperationRecordDTO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public interface UserOperationRecordMapper extends BaseMapper<UserOperationRecordDTO> {

    /**
     * 更新updateTime时间
     * @param userPageModeDTO
     * @return
     */
    int updateTime(UserOperationRecordDTO userPageModeDTO);

    /**
     * 删除占用
     * @param params
     * @return
     */
    int deleteUserOperationRecord(Map<String, Object> params);

    /**
     * 批量删除占用
     * @param userOperationRecords
     * @return
     */
    int batchDeleteUserOperationRecord(List<UserOperationRecordDTO> userOperationRecords);

    /**
     * 批量删除占用
     * @param params
     * @return
     */
    int batchDeleteTakeUpUser(Map<String, Object> params);

    /**
     * 更新占用时间
     * @param userPageModeDTO
     * @return
     */
    int deleteExpire(UserOperationRecordDTO userPageModeDTO);

    /**
     * 更新占用时间
     * @param userPageModeDTO
     * @return
     */
    int updateUserOperationRecord(UserOperationRecordDTO userPageModeDTO);

    /**
     * 查询有效期内的记录
     * @param params
     * @return
     */
    List<UserOperationRecordDTO> queryEffectiveRecords(Map<String, Object> params);

    /**
     * 查询过期的记录
     * @param params
     * @return
     */
    List<UserOperationRecordDTO> queryExpireRecords(Map<String, Object> params);

    /**
     * 批量插入占用记录
     * @param userOperationRecordDTOList
     * @return
     */
    int batchInsertTakeUpRecords(@Param("userOperationRecordDTOList")List<UserOperationRecordDTO> userOperationRecordDTOList);


}
