package com.digiwin.athena.base.infrastructure.meta.po.trial;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/06 15:43:44
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "trial_scene_step")
public class TrialSceneStepData extends BaseEntity<TrialSceneStepData> implements Serializable {
    @TableId()
    private Long id;
    /**
     * 场景id
     */
    private Long sceneId;
    /**
     * 步骤id
     */
    private Long stepId;

    /**
     * 场景KEY
     */
    private String sceneKey;
    /**
     * 步骤KEY
     */
    private String stepKey;
    /**
     * 排序
     */
    @TableField("`rank`")
    private int rank;

}
