/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.importstatistics.kg;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.application.Application;
import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.kg.dto.ApplicationRelationReqByTypeAndCodesDTO;
import com.digiwin.athena.atdm.importstatistics.kg.dto.ApplicationRelationRespDTO;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class DataEntryKgService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEntryKgService.class);
    @Value(value="${themeMap.uri}")
    private String knowledgeGraphUrl;
    @Value(value="${themeMap.dataMapUri}")
    private String datamapUrl;
    private static final String APPLICATION_NAMEANDTAG_CONFIG = "/restful/standard/datamap/app/byNameAndTags";
    private static final String QUERY_DIGITALSTAFF = "/restful/service/knowledgegraph/app/queryDigitalStaffByCode";
    private static final String GET_ENHANCE_BYAPPCODE = "/restful/service/knowledgegraph/app/enhanceByAppCode?code={code}";
    private static final String BY_CODES_AND_TYPE = "/restful/standard/datamap/app/applicationRelationsByCodesAndType";
    private static final String APPLICATION_BY_TYPE_AND_CODE = "/restful/standard/datamap/app/applicationByTypeAndCode?type={type}&code={code}";

    public DapResponse<List<Application>> getApplicationByNameAndTags(String applicationName, List<String> tags) {
        String url = UriComponentsBuilder.fromUriString((String)(this.datamapUrl + APPLICATION_NAMEANDTAG_CONFIG)).queryParam("applicationName", new Object[]{StringUtils.isNotBlank((CharSequence)applicationName) ? applicationName : ""}).queryParam("tags", (Collection)(CollectionUtils.isNotEmpty(tags) ? tags : new ArrayList())).build().toUriString();
        return (DapResponse)DwSpringHttpUtil.get((String)url, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<List<Application>>>(){});
    }

    public DapResponse<Map<String, List>> getDigitalStaff(Set<String> codeList, Set<String> enhanceCodeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0088.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.codeListEmpty", (Object[])new Object[0]));
        }
        HashMap<String, Set<String>> params = new HashMap<String, Set<String>>();
        params.put("codeList", codeList);
        params.put("enhanceCodeList", enhanceCodeList);
        return (DapResponse)DwSpringHttpUtil.post((String)(this.knowledgeGraphUrl + QUERY_DIGITALSTAFF), params, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<Map<String, List>>>(){});
    }

    public DapResponse<List<Application>> getEnhancebyAppCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0089.getErrCode(), (String)MessageUtil.getMessage((String)"delivery.delivery.codeEmpty", (Object[])new Object[0]));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        return (DapResponse)DwSpringHttpUtil.get((String)(this.knowledgeGraphUrl + GET_ENHANCE_BYAPPCODE), (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<List<Application>>>(){}, params);
    }

    public DapResponse<List<ApplicationRelationRespDTO>> postApplicationRelationsByCodesAndType(List<String> code, String type) {
        HashMap<String, ApplicationRelationReqByTypeAndCodesDTO> params = new HashMap<String, ApplicationRelationReqByTypeAndCodesDTO>();
        ApplicationRelationReqByTypeAndCodesDTO applicationRelationReqByTypeAndCodesDTO = new ApplicationRelationReqByTypeAndCodesDTO();
        applicationRelationReqByTypeAndCodesDTO.setCodes(code);
        applicationRelationReqByTypeAndCodesDTO.setType(type);
        params.put("applicationRelationQueryDTO", applicationRelationReqByTypeAndCodesDTO);
        return (DapResponse)DwSpringHttpUtil.post((String)(this.datamapUrl + BY_CODES_AND_TYPE), params, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<List<ApplicationRelationRespDTO>>>(){});
    }

    public DapResponse<ApplicationRelationRespDTO> getApplicationByTypeAndCode(String type, String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type);
        params.put("code", code);
        String url = this.datamapUrl + APPLICATION_BY_TYPE_AND_CODE;
        return (DapResponse)DwSpringHttpUtil.get((String)url, (ParameterizedTypeReference)new ParameterizedTypeReference<DapResponse<ApplicationRelationRespDTO>>(){}, params);
    }
}

