package com.digiwin.athena.atdm.importstatistics.application;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

@Data
public class OperationUnit {
    private String eoc_company_id;
    private String eoc_company_name;
    private String eoc_site_id;
    private String eoc_site_name;
    private String eoc_region_id;
    private String eoc_region_name;
    private String eoc_group_name;

    public boolean isEmpty() {
        return StringUtils.isEmpty(eoc_company_id) && StringUtils.isEmpty(eoc_site_id) && StringUtils.isEmpty(eoc_region_id);
    }

    public Map<String, String> transToEocMap() {
        Map<String, String> eocMap = new HashMap<>();
        eocMap.put("eoc_company_id", StringUtils.isEmpty(eoc_company_id) ? "" : eoc_company_id);
        eocMap.put("eoc_site_id", StringUtils.isEmpty(eoc_site_id) ? "" : eoc_site_id);
        eocMap.put("eoc_region_id", StringUtils.isEmpty(eoc_region_id) ? "" : eoc_region_id);
        return eocMap;
    }

    public Map<String, String> transToEocMapDTO() {
        Map<String, String> eocMap = new HashMap<>();
        eocMap.put("eocCompanyId", StringUtils.isEmpty(eoc_company_id) ? "" : eoc_company_id);
        eocMap.put("eocSiteId", StringUtils.isEmpty(eoc_site_id) ? "" : eoc_site_id);
        eocMap.put("eocRegionId", StringUtils.isEmpty(eoc_region_id) ? "" : eoc_region_id);
        return eocMap;
    }

    public String getEocLevel() {
        if (isEmpty()) {
            return null;
        }
        String level = null;
        if (StringUtils.isNotEmpty(this.getEoc_region_id()) &&
                StringUtils.isEmpty(this.getEoc_company_id()) &&
                StringUtils.isEmpty(this.getEoc_site_id())) {
            level = "region";
        }
        if (StringUtils.isEmpty(this.getEoc_region_id()) &&
                StringUtils.isNotEmpty(this.getEoc_company_id()) &&
                StringUtils.isNotEmpty(this.getEoc_site_id())) {
            level = "site";
        }
        if (StringUtils.isEmpty(this.getEoc_region_id()) &&
                StringUtils.isNotEmpty(this.getEoc_company_id()) &&
                StringUtils.isEmpty(this.getEoc_site_id())) {
            level = "company";
        }
        return level;
    }

    public String getOperationUnitName() {
        String name = "";
        if (StringUtils.isEmpty(this.getEoc_region_id()) &&
                StringUtils.isNotEmpty(this.getEoc_company_id()) &&
                StringUtils.isNotEmpty(this.getEoc_site_id())) {
            name = eoc_site_name;
        }
        if (StringUtils.isEmpty(this.getEoc_region_name()) &&
                StringUtils.isEmpty(this.getEoc_company_name()) &&
                StringUtils.isNotEmpty(this.getEoc_group_name())) {
            name = eoc_group_name;
        }
        if (StringUtils.isEmpty(this.getEoc_region_name()) &&
                StringUtils.isNotEmpty(this.getEoc_company_name()) &&
                StringUtils.isEmpty(this.getEoc_site_name())) {
            name = eoc_company_name;
        }
        return name;
    }

    public String getOperationUnitCode() {
        String code = "";
        if (StringUtils.isEmpty(this.getEoc_region_id()) &&
                StringUtils.isNotEmpty(this.getEoc_company_id()) &&
                StringUtils.isNotEmpty(this.getEoc_site_id())) {
            code = eoc_site_id;
        }
        if (StringUtils.isEmpty(this.getEoc_region_id()) &&
                StringUtils.isEmpty(this.getEoc_company_id()) &&
                StringUtils.isNotEmpty(this.getEoc_group_name())) {
            code = "";
        }
        if (StringUtils.isEmpty(this.getEoc_region_id()) &&
                StringUtils.isNotEmpty(this.getEoc_company_id()) &&
                StringUtils.isEmpty(this.getEoc_site_id())) {
            code = eoc_company_id;
        }
        return code;
    }

    public String getOperationUnitType() {
        String type = "corp";
        if (StringUtils.isEmpty(this.getEoc_region_id()) &&
                StringUtils.isNotEmpty(this.getEoc_company_id()) &&
                StringUtils.isNotEmpty(this.getEoc_site_id())) {
            type = "factory";
        }
        if (StringUtils.isEmpty(this.getEoc_region_id()) &&
                StringUtils.isEmpty(this.getEoc_company_id()) &&
                StringUtils.isNotEmpty(this.getEoc_group_name())) {
            type = "corp";
        }
        if (StringUtils.isEmpty(this.getEoc_region_id()) &&
                StringUtils.isNotEmpty(this.getEoc_company_id()) &&
                StringUtils.isEmpty(this.getEoc_site_id())) {
            type = "company";
        }
        return type;
    }
}