/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.importstatistics.cac;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DataEntryCacService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEntryCacService.class);
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${cac.uri}")
    private String cacUrl;
    private final String AUTHORIZATIONS_TENANTS = "authorizations/tenants/";

    public Set<String> getAithorizationsApplication(String tenantId) {
        HashSet<String> appLists = new HashSet<String>();
        Object obj = this.authorizationsTenants(tenantId);
        if (obj == null) {
            return appLists;
        }
        List jsonArray = JsonUtils.jsonToListObject((String)JsonUtils.objectToString((Object)obj), Map.class);
        for (int i = 0; i < jsonArray.size(); ++i) {
            DateTimeFormatter dtf2;
            String code = String.valueOf(((Map)jsonArray.get(i)).get("code"));
            String expiredTime = String.valueOf(((Map)jsonArray.get(i)).get("expiredTime"));
            LocalDateTime expiredLocalDateTime = LocalDateTime.parse(expiredTime, dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            if (expiredLocalDateTime.isBefore(LocalDateTime.now())) {
                log.info("app:{} \u5df2\u7ecf\u8fc7\u671f\u4e86\uff0c expiredTime\uff1a{}", (Object)code, (Object)expiredTime);
                continue;
            }
            appLists.add(code);
        }
        return appLists;
    }

    public Object authorizationsTenants(String tenantId) {
        String requestUrl = this.cacUrl + "authorizations/tenants/" + tenantId;
        HttpHeaders headers = new HttpHeaders();
        if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
            headers.set("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        }
        headers.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity exchange = this.restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, Object.class, new Object[0]);
        Object forObject = exchange.getBody();
        return forObject;
    }
}

