package com.digiwin.athena.atdm.importstatistics.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @ClassName ImportStatisticsPO
 * @Description 导入统计数据
 * @Author zhuangli
 * @Date 2021/4/6 14:01
 * @Version 1.0
 **/
@Data
public class ImportStatistics {

    private Long id;
    private String masterId;
    private String activityId;
    private String activityName;
    private String userId;
    private String userJson;
    private String userToken;
    private String locale;
    private String actionId;
    private Integer succeededNum;
    private Integer processingNum;
    private Integer failedNum;
    // 错误个数
    private Integer errorNum;
    private String failedUrl;
    private Integer republished;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    private List<ImportBatchRecord> importBatchRecords;
    private String routerKey;
    private String actionInfo;

}
