package com.digiwin.athena.base.infrastructure.constant;

public final class Constants {
    private Constants() {
    }

    public static final long USER_TRACK_DATA_TTL = 100;

    public static final String ATHENA_APPID = "Athena";

    public static final char SEMICOLON = ':';

    /**
     * 是否占用：0.否
     */
    public static final String USER_OPERATION_TAKE_UP_NO = "0";

    /**
     * 是否占用：1.是
     */
    public static final String USER_OPERATION_TAKE_UP_YES = "1";

    /**
     * 页面类型：0.基础资料
     */
    public static final String USER_OPERATION_PAGE_TYPE_DATA_ENTRY = "0";

    /**
     * MQTT消息类别：基础资料
     */
    public static final String USER_OPERATION_MSG_TYPE_BASE_DATA = "baseDataEntry";

    /**
     * MQTT消息类型：占用
     */
    public static final String USER_OPERATION_MSG_CATEGORY_TAKE_UP = "takeUp";

    /**
     * MQTT消息类型：释放
     */
    public static final String USER_OPERATION_MSG_CATEGORY_RELEASE = "release";

    /**
     * 用户操作有效时间：10分钟
     */
    public static long USER_OPERATION_TTL = 600;

    /**
     * 排序字段key常量
     */
    /**
     * 任务类型
     */
    public static final String TASK_TYPE = "TASK_TYPE";

    /**
     * 完成时间/项目时间
     */
    public static final String TIME = "TIME";
    /**
     * 阅读状态
     */
    public static final String READ_STATUS = "READ_STATUS";
    /**
     * 项目名称
     */
    public static final String NAME = "NAME";
    /**
     * 异常/逾期状态
     */
    public static final String OVERDUE_EXCEPTION = "OVERDUE_EXCEPTION";

    /**
     * 未购买作业
     */
    public static final String ACCESS_NO_BUY = "NOBUY";
}
