/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.manager.emc;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.emc.BaseSendEmailService;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BaseSendEmailServiceImpl
implements BaseSendEmailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseSendEmailServiceImpl.class);
    private static final String SEND_EMAIL_URL = "/api/emc/v1/message/email";
    @Value(value="${emc.uri:}")
    private String emcUri;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void sendEmail(JSONObject content) {
        log.info("[SendEmail] SendEmailService start: {}", (Object)content);
        String url = this.emcUri + SEND_EMAIL_URL;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)content, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class, new Object[0]);
        Object code = ((HashMap)respEntity.getBody()).get("code");
        Object success = ((HashMap)respEntity.getBody()).get("success");
        try {
            if (!this.requestSuccess(code, success)) {
                String errorMessage = this.messageUtils.getMessage("emc.v1.message.email");
                log.error("{}, \u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c{}, {}", new Object[]{AudcErrorCodeEnum.EMC_V1_MESSAGE_EMAIL.getErrCode(), errorMessage, "status code: 200, code: " + String.valueOf(code) + ", message: " + String.valueOf(((HashMap)respEntity.getBody()).get("message"))});
                throw BusinessException.create((String)AudcErrorCodeEnum.EMC_V1_MESSAGE_EMAIL.getErrCode(), (String)errorMessage);
            }
        }
        catch (Exception ex) {
            throw ExceptionUtil.wrap((String)AudcErrorCodeEnum.EMC_V1_MESSAGE_EMAIL.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public void sendEmailWithTemplate(String templateId, String receiver, Map<String, Object> emailData) {
        JSONObject emailJson = new JSONObject();
        emailJson.put((Object)"eventId", (Object)templateId);
        JSONObject emailMsg = new JSONObject();
        emailMsg.put((Object)"data", emailData);
        emailJson.put((Object)"message", (Object)emailMsg);
        emailJson.put((Object)"contacts", (Object)receiver);
        this.sendEmail(emailJson);
    }

    private boolean requestSuccess(Object code, Object success) {
        if (null == code || null == success) {
            return false;
        }
        return StringUtils.equals((CharSequence)String.valueOf(code), (CharSequence)String.valueOf(200)) && Boolean.valueOf(String.valueOf(success)) != false;
    }
}

