/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.mongo;

import com.digiwin.athena.base.infrastructure.meta.po.userdefined.mongo.UserDefineData;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class AgileReportUserDefineMongoMapper {
    @Resource
    private MongoTemplate userdefinedMongoTemplate;
    private String COLLECTION_NAME = "user_defined_gridster";

    public void save(UserDefineData userDefineData) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"snapshotId").is((Object)userDefineData.getSnapshotId()).and("tenantId").is((Object)userDefineData.getTenantId()).and("userId").is((Object)userDefineData.getUserId()));
        Boolean exists = this.userdefinedMongoTemplate.exists(query, this.COLLECTION_NAME);
        Update update = new Update();
        if (exists.booleanValue()) {
            update.set("updateDate", (Object)LocalDateTime.now());
            update.set("dashboard", userDefineData.getDashboard());
            this.userdefinedMongoTemplate.upsert(query, (UpdateDefinition)update, this.COLLECTION_NAME);
        } else {
            userDefineData.setCreateDate(LocalDateTime.now());
            this.userdefinedMongoTemplate.insert((Object)userDefineData, this.COLLECTION_NAME);
        }
    }

    public List<UserDefineData> getUserDefine(String snapshotId, String userId, String tenantId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId).and("snapshotId").is((Object)snapshotId).and("tenantId").is((Object)tenantId));
        return this.userdefinedMongoTemplate.find(query, UserDefineData.class, this.COLLECTION_NAME);
    }

    public boolean existUserDefineData(String userId, String tenantId, String snapshotId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"snapshotId").is((Object)snapshotId).and("tenantId").is((Object)tenantId).and("userId").is((Object)userId));
        Boolean existRecord = this.userdefinedMongoTemplate.exists(query, this.COLLECTION_NAME);
        return existRecord;
    }
}

