/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.mongo;

import com.digiwin.athena.base.infrastructure.meta.po.usertrack.mongo.UserTrackExtendDTO;
import com.digiwin.athena.base.infrastructure.mongo.AbstractMongoMapper;
import com.digiwin.athena.base.infrastructure.util.DataFilterUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class UserTrackMongoMapper
extends AbstractMongoMapper {
    private static final String COLLECTION_NAME_SUFFIX = "_track";
    @Resource
    private MongoTemplate trackMongoTemplate;
    private static final Map<String, Object> trackCollectIndex = new HashMap<String, Object>();

    public void safeSaveTrackData(String tenantId, List<UserTrackExtendDTO> tenantTrackList) {
        String collectionName = this.getCollectionName(tenantId);
        trackCollectIndex.put("uniqueId", -1);
        this.safeCreateCollectionWithIndex(this.trackMongoTemplate, collectionName, trackCollectIndex, 100L, TimeUnit.DAYS);
        this.safeSaveData(collectionName, tenantTrackList);
    }

    public void saveData(String collection, List<UserTrackExtendDTO> dataList) {
        BulkOperations operations = this.trackMongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collection);
        operations.insert(dataList);
        operations.execute();
    }

    public void safeSaveData(String collection, List<UserTrackExtendDTO> dataList) {
        try {
            this.saveData(collection, dataList);
        }
        catch (IllegalArgumentException ex) {
            for (UserTrackExtendDTO data : dataList) {
                DataFilterUtils.removeMongoIllegalNameField(data.getWorkContent());
                DataFilterUtils.removeMongoIllegalNameField(data.getAttachData());
            }
            this.saveData(collection, dataList);
        }
    }

    public void dropCollection(String collection) {
        this.trackMongoTemplate.dropCollection(collection);
    }

    public List<UserTrackExtendDTO> findByParam(String collectionName, Query query) {
        return this.trackMongoTemplate.find(query, UserTrackExtendDTO.class, collectionName);
    }

    private String getCollectionName(String tenantId) {
        return tenantId + COLLECTION_NAME_SUFFIX;
    }
}

