package com.digiwin.athena.atdm.importstatistics.cac;


import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
@Slf4j
public class DataEntryCacService {
    @Autowired
    RestTemplate restTemplate;

    @Value("${cac.uri}")
    private String cacUrl;

    private final String AUTHORIZATIONS_TENANTS = "authorizations/tenants/";

    public Set<String> getAithorizationsApplication(String tenantId){
        Set<String> appLists = new HashSet<>();
        Object obj = this.authorizationsTenants(tenantId);
        if( obj == null){
            return appLists;
        }
        List<Map> jsonArray= JsonUtils.jsonToListObject(JsonUtils.objectToString(obj), Map.class);
        for(int i = 0 ; i < jsonArray.size(); i++){
            String code = String.valueOf(jsonArray.get(i).get("code"));
            String expiredTime = String.valueOf(jsonArray.get(i).get("expiredTime"));
            DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime expiredLocalDateTime = LocalDateTime.parse(expiredTime, dtf2);
            if(expiredLocalDateTime.isBefore(LocalDateTime.now())){
                log.info("app:{} 已经过期了， expiredTime：{}",  code, expiredTime);
                continue;
            }
            appLists.add(code);
        }
        return appLists;
    }

    public Object authorizationsTenants(String tenantId){
        String requestUrl = cacUrl + AUTHORIZATIONS_TENANTS + tenantId;
        HttpHeaders headers = new HttpHeaders();
        if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
            headers.set("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        }
        headers.set("digi-middleware-auth-app", GlobalConstant.IAM_APP_TOKEN_ATHENA);
        HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>( headers);
        ResponseEntity<Object> exchange = restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, Object.class);
        Object forObject = exchange.getBody();
        return forObject;
    }
}
