package com.digiwin.athena.atdm.importstatistics.kg;


import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.application.Application;
import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.kg.dto.ApplicationRelationReqByTypeAndCodesDTO;
import com.digiwin.athena.atdm.importstatistics.kg.dto.ApplicationRelationRespDTO;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-04-29 13:43
 **/
@Slf4j
@Service
public class DataEntryKgService {

    @Value("${themeMap.uri}")
    private String knowledgeGraphUrl;

    @Value("${themeMap.dataMapUri}")
    private String datamapUrl;

    private static final String APPLICATION_NAMEANDTAG_CONFIG = "/restful/standard/datamap/app/byNameAndTags";
    public DapResponse<List<Application>> getApplicationByNameAndTags(String applicationName, List<String> tags) {
        String url = UriComponentsBuilder.fromUriString(datamapUrl + APPLICATION_NAMEANDTAG_CONFIG)
                .queryParam("applicationName", StringUtils.isNotBlank(applicationName) ? applicationName : "")
                .queryParam("tags", CollectionUtils.isNotEmpty(tags) ? tags : new ArrayList<>())
                .build()
                .toUriString();

        return DwSpringHttpUtil.get(url, new ParameterizedTypeReference<DapResponse<List<Application>>>() {
        });
    }


    private static final String QUERY_DIGITALSTAFF = "/restful/service/knowledgegraph/app/queryDigitalStaffByCode";
    public DapResponse<Map<String, List>> getDigitalStaff(Set<String> codeList, Set<String> enhanceCodeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0088.getErrCode(), MessageUtil.getMessage("delivery.codeListEmpty"));
        }

        Map<String, Object> params = new HashMap<>();
        params.put("codeList", codeList);
        params.put("enhanceCodeList", enhanceCodeList);

        return DwSpringHttpUtil.post(knowledgeGraphUrl + QUERY_DIGITALSTAFF, params, new ParameterizedTypeReference<DapResponse<Map<String, List>>>() {
        });
    }


    private static final String GET_ENHANCE_BYAPPCODE = "/restful/service/knowledgegraph/app/enhanceByAppCode?code={code}";
    public DapResponse<List<Application>> getEnhancebyAppCode(String code) {
        if (StringUtils.isEmpty(code)) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0089.getErrCode(), MessageUtil.getMessage("delivery.delivery.codeEmpty"));
        }

        Map<String, Object> params = new HashMap<>();
        params.put("code", code);

        return DwSpringHttpUtil.get(knowledgeGraphUrl + GET_ENHANCE_BYAPPCODE, new ParameterizedTypeReference<DapResponse<List<Application>>>() {
        }, params);
    }


    private static final String BY_CODES_AND_TYPE = "/restful/standard/datamap/app/applicationRelationsByCodesAndType";

    public DapResponse<List<ApplicationRelationRespDTO>> postApplicationRelationsByCodesAndType(List<String> code, String type) {
        Map<String, Object> params = new HashMap<>();
        ApplicationRelationReqByTypeAndCodesDTO applicationRelationReqByTypeAndCodesDTO = new ApplicationRelationReqByTypeAndCodesDTO();
        applicationRelationReqByTypeAndCodesDTO.setCodes(code);
        applicationRelationReqByTypeAndCodesDTO.setType(type);
        params.put("applicationRelationQueryDTO", applicationRelationReqByTypeAndCodesDTO);

        return DwSpringHttpUtil.post(datamapUrl + BY_CODES_AND_TYPE, params, new ParameterizedTypeReference<DapResponse<List<ApplicationRelationRespDTO>>>() {
        });
    }



    private static final String APPLICATION_BY_TYPE_AND_CODE = "/restful/standard/datamap/app/applicationByTypeAndCode?type={type}&code={code}";

    public DapResponse<ApplicationRelationRespDTO> getApplicationByTypeAndCode(String type, String code) {
        Map<String, Object> params = new HashMap<>();
        params.put("type", type);
        params.put("code", code);

        String url = datamapUrl + APPLICATION_BY_TYPE_AND_CODE;
        return DwSpringHttpUtil.get(url, new ParameterizedTypeReference<DapResponse<ApplicationRelationRespDTO>>() {
        }, params);
    }

}
