package com.digiwin.athena.atdm.importstatistics.util;

import org.springframework.stereotype.Component;

import java.util.BitSet;

@Component
public class BloomFilter {

    private static final int DEFAULT_SIZE = 2 << 24;
    private static final int[] SEEDS = new int[]{3, 5, 7, 11, 13, 31, 37, 61};
    private BitSet bitSet = new BitSet(DEFAULT_SIZE);

    private int getHash(int seed, String value) {
        int result = 0;
        int len = value.length();
        for (int i = 0; i < len; i++) {
            result = seed * result + value.charAt(i);
        }
        return (DEFAULT_SIZE - 1) & result;
    }

    public void add(String value) {
        for (int seed : SEEDS) {
            int hash = getHash(seed, value);
            bitSet.set(hash, true);
        }
    }

    public boolean contains(String value) {
        if (value == null) {
            return false;
        }
        for (int seed : SEEDS) {
            int hash = getHash(seed, value);
            if (!bitSet.get(hash)) {
                return false;
            }
        }
        return true;
    }

}
