package com.digiwin.athena.base.infrastructure.meta.po.cofw;

import com.baomidou.mybatisplus.annotation.TableId;
import com.digiwin.athena.appcore.domain.LanguageMark;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 快照存储实体类
 *
 * @author xuxx
 * @version 1.0
 * @date 2021/08/27
 */
@Data
public class Cofw {

    @TableId()
    private Long id;
    /**
     * 快照名称，需支持多语系,cofw.cofw_name
     */
    @LanguageMark
    private String cofwName;
    /**
     * 用户ID，当前登录账号
     */
    private String userId;

    /**
     * 当前登录用户所在租户ID
     */
    private String tenantId;
    /**
     * 用户名称，当前登录账号对应显示的名称
     */
    private String userName;
    /**
     * 快照类型：0任务型、1项目型、2报表型
     */
    private int cofwType;
    /**
     * 业务主键编号，存放快照业务实例主键
     */
    private long businessId;
    /**
     * 快照备注：用于存放业务数据所需要的具体实例，如项目存放来源，任务存放任务名称和单号，报表存放报表名称条件组合的JSON
     */
    private Object cofwMark;
    /**
     * 快照内容
     */
    private Object cofwContent;
    /**
     * 储存时间
     */
    private LocalDateTime createTime;
    /**
     * 修改人登录账号
     */
    private String modifyUserId;
    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;
    /**
     * 删除人登录账号
     */
    private String delUserId;
    /**
     * 删除标记：0有效；1删除
     */
    private int delFlag;
    /**
     * 删除时间
     */
    private LocalDateTime delTime;
}
