package com.digiwin.athena.base.infrastructure.meta.po.commonused;

import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "task_card_list_config")
public class TaskCardListConfigData extends BaseEntity<TaskCardListConfigData> implements Serializable {

    private String tenantId;
    private String userId;
    private String config;
    private String groupId;
    /**
     * 0:任务:tm_activity_id; 1:项目:tm_task_id
     */
    private Integer groupType;
    /**
     * task-我的任务；team-tasks-团队任务（；project-我的项目；team-projects-团队任务）
     */
    private String pageCode;
}
