package com.digiwin.athena.base.infrastructure.meta.po.userdefined.mongo;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 高级查询条件
 */
@Data
public class ActionSearchInfoMapping {

    /**
     * 搜索字段显示的名称
     */
    private String searchName;

    /**
     * 搜索字段名，对应schema
     */
    private String searchField;

    /**
     * 数据类型
     * 当枚举时(SELECT)
     * options必配
     */
    private String dataType;

    /**
     * select 编辑器的选项列表
     * title:  显示值
     * value:  实际值
     */
    private List<Map<String, Object>> options;

    /**
     * 数据值
     */
    private Object searchValue;
    /**
     * constant为固定变量
     */
    private String paramType;

    /**
     * like  等等
     */
    private String searchOperator;

    /**
     * 条件的排序信息
     */
    private Integer order;

    /**
     * 英文左右括号符号"(",")"
     */
    private String bracket;

    /**
     * 逻辑信息 and 或者or ，其他暂不支持
     */
    private String logic;

    /**
     * 与前一条件的逻辑关系，and 或者 or
     */
    private String preLogic;


}
