/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.manager.eoc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.eoc.BaseEocService;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EmpAgentSaveReqDTO;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EmpInfoDTO;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EocBaseResultDTO;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EocEmpInfoDTO;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EocResultDTO;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EocTenantAllUserDTO;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BaseEocServiceImpl
implements BaseEocService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseEocServiceImpl.class);
    @Value(value="${eoc.uri:}")
    private String eocUri;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private MessageUtils messageUtils;

    @Override
    public List<EmpInfoDTO> queryEmpDeptInfoByUserId(List<String> userIds, int pageNum, int pageSize) {
        String url = this.eocUri + "/api/eoc/v2/emp/simple?pageNum=1&pageSize={pageSize}&params={params}";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userIds", userIds);
        params.put("bindUser", true);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pageNum", String.valueOf(pageNum));
        param.put("pageSize", String.valueOf(pageSize));
        param.put("params", JsonUtils.objectToString(params));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<EocBaseResultDTO<EocTenantAllUserDTO>>(){}, param);
        Integer code = ((EocBaseResultDTO)responseEntity.getBody()).getCode();
        try {
            if (StringUtils.equals((CharSequence)String.valueOf(code), (CharSequence)String.valueOf(200))) {
                return ((EocTenantAllUserDTO)((EocBaseResultDTO)responseEntity.getBody()).getData()).getList();
            }
            String errorMessage = this.messageUtils.getMessage("eoc.v2.emp.simple");
            log.error("{}, {}, {}", new Object[]{AudcErrorCodeEnum.EOC_V2_EMP_SIMPLE.getErrCode(), errorMessage, "status code: 200, code: " + String.valueOf(code) + ", message: " + String.valueOf(((EocBaseResultDTO)responseEntity.getBody()).getMessage())});
            throw BusinessException.create((String)AudcErrorCodeEnum.EOC_V2_EMP_SIMPLE.getErrCode(), (String)errorMessage);
        }
        catch (Exception ex) {
            throw ExceptionUtil.wrap((String)AudcErrorCodeEnum.EOC_V2_EMP_SIMPLE.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public void empAgentChange(EmpAgentSaveReqDTO proxyInfoSaveReq, AuthoredUser user) {
        String url = this.eocUri + "/api/eoc/v2/emp/agent/change";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", proxyInfoSaveReq.getUserId());
        param.put("agentId", proxyInfoSaveReq.getAgentId());
        param.put("agentBeginDate", proxyInfoSaveReq.getAgentBeginDate());
        param.put("agentEndDate", proxyInfoSaveReq.getAgentEndDate());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", user.getToken());
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            log.info("/api/eoc/v2/emp/agent/change request param", (Object)JsonUtils.objectToString(param));
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<EocBaseResultDTO>(){}, new Object[0]);
            log.info("/api/eoc/v2/emp/agent/change response", (Object)JsonUtils.objectToString((Object)responseEntity));
            if (Objects.isNull(responseEntity) || Objects.isNull(responseEntity.getBody()) || !StringUtils.equals((CharSequence)String.valueOf(((EocBaseResultDTO)responseEntity.getBody()).getCode()), (CharSequence)String.valueOf(200))) {
                String errorMessage = this.messageUtils.getMessage("eoc.v2.emp.agent.change");
                log.error("{}, {}, {}", new Object[]{AudcErrorCodeEnum.EOC_V2_EMP_AGENT_CHANGE.getErrCode(), errorMessage, responseEntity});
                throw BusinessException.create((String)AudcErrorCodeEnum.EOC_V2_EMP_AGENT_CHANGE.getErrCode(), (String)errorMessage);
            }
        }
        catch (Exception ex) {
            throw ExceptionUtil.wrap((String)AudcErrorCodeEnum.EOC_V2_EMP_AGENT_CHANGE.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public void batchEmpAgentChange(List<EmpAgentSaveReqDTO> needSendMsgToEocList, AuthoredUser user) {
        String url = this.eocUri + "/api/eoc/v2/emp/agent/change/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", user.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)JsonUtils.objectToString(needSendMsgToEocList), (MultiValueMap)headers);
        try {
            log.info("/api/eoc/v2/emp/agent/change/batch request param", (Object)JsonUtils.objectToString(needSendMsgToEocList));
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<EocBaseResultDTO>(){}, new Object[0]);
            log.info("/api/eoc/v2/emp/agent/change response", (Object)JsonUtils.objectToString((Object)responseEntity));
            if (Objects.isNull(responseEntity) || Objects.isNull(responseEntity.getBody()) || !StringUtils.equals((CharSequence)String.valueOf(((EocBaseResultDTO)responseEntity.getBody()).getCode()), (CharSequence)String.valueOf(200))) {
                String errorMessage = this.messageUtils.getMessage("eoc.v2.emp.agent.change");
                log.error("{}, {}, {}", new Object[]{AudcErrorCodeEnum.EOC_V2_EMP_AGENT_CHANGE.getErrCode(), errorMessage, responseEntity});
                throw BusinessException.create((String)AudcErrorCodeEnum.EOC_V2_EMP_AGENT_CHANGE.getErrCode(), (String)errorMessage);
            }
        }
        catch (Exception ex) {
            throw ExceptionUtil.wrap((String)AudcErrorCodeEnum.EOC_V2_EMP_AGENT_CHANGE.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public void empAgentClear(String userId, AuthoredUser user) {
        String url = this.eocUri + "/api/eoc/v2/emp/agent/clear";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", user.getToken());
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            log.info("/api/eoc/v2/emp/agent/clear request param", (Object)JsonUtils.objectToString(param));
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<EocBaseResultDTO>(){}, new Object[0]);
            log.info("/api/eoc/v2/emp/agent/clear response", (Object)JsonUtils.objectToString((Object)responseEntity));
            if (Objects.isNull(responseEntity) || Objects.isNull(responseEntity.getBody()) || !StringUtils.equals((CharSequence)String.valueOf(((EocBaseResultDTO)responseEntity.getBody()).getCode()), (CharSequence)String.valueOf(200))) {
                String errorMessage = this.messageUtils.getMessage("eoc.v2.emp.agent.clear");
                log.error("{}, {}, {}", new Object[]{AudcErrorCodeEnum.EOC_V2_EMP_AGENT_CLEAR.getErrCode(), errorMessage, responseEntity});
                throw BusinessException.create((String)AudcErrorCodeEnum.EOC_V2_EMP_AGENT_CLEAR.getErrCode(), (String)errorMessage);
            }
        }
        catch (Exception ex) {
            throw ExceptionUtil.wrap((String)AudcErrorCodeEnum.EOC_V2_EMP_AGENT_CLEAR.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public JSONArray queryCurrentTenantAllDepartment() {
        String uri = this.eocUri + "/api/eoc/v2/dept/list?pageNum=1&pageSize={pageSize}";
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("pageSize", 9999);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, EocResultDTO.class, params);
        EocResultDTO result = (EocResultDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return JSONArray.fromObject(((LinkedHashMap)result.getData()).get("list"));
        }
        return new JSONArray();
    }

    @Override
    public List<EocEmpInfoDTO> queryMembersOfTheDepartment(String departmentSid) {
        String uri = this.eocUri + "/api/eoc/v2/dept/{departmentSid}/emps?pageNum=1&pageSize={pageSize}&params={statusParam}";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("departmentSid", departmentSid);
        params.put("pageSize", 9999);
        HashMap<String, Boolean> status = new HashMap<String, Boolean>();
        status.put("status", true);
        params.put("statusParam", JSON.toJSONString(status));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, EocResultDTO.class, params);
        EocResultDTO result = (EocResultDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return JSONObject.parseArray((String)JSONObject.toJSONString(((LinkedHashMap)result.getData()).get("list")), EocEmpInfoDTO.class);
        }
        return Collections.emptyList();
    }
}

