/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.mongo;

import com.digiwin.athena.base.infrastructure.util.DistributeLocker;
import com.mongodb.client.model.IndexOptions;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.tomcat.util.buf.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class AbstractMongoMapper {
    public static final String LOCK_NAME_SUFFIX = ":createMongoCollection:lock";
    public static final String LOCK_NAME_PREFIX = "audc:";
    @Resource(name="redisTemplate")
    private RedisTemplate lockRedisTemplate;
    protected ConcurrentHashMap<String, String> existCollections = new ConcurrentHashMap();

    protected void safeCreateCollectionWithIndex(MongoTemplate mongoTemplate, String collectionName, Map<String, Object> indexMap) {
        this.safeCreateCollectionWithIndex(mongoTemplate, collectionName, indexMap, null, null);
    }

    protected void safeCreateCollectionWithIndex(MongoTemplate mongoTemplate, String collectionName, Map<String, Object> indexMap, Long expireAfter, TimeUnit timeUnit) {
        if (this.existCollections.contains(collectionName)) {
            return;
        }
        if (mongoTemplate.collectionExists(collectionName)) {
            this.existCollections.put(collectionName, "1");
            return;
        }
        String tmpLockName = LOCK_NAME_PREFIX + collectionName + LOCK_NAME_SUFFIX;
        DistributeLocker.tryLock30s(this.lockRedisTemplate, tmpLockName, () -> this.createCollectionWithIndex(mongoTemplate, collectionName, indexMap, expireAfter, timeUnit));
    }

    protected void createCollectionWithIndex(MongoTemplate mongoTemplate, String collectionName, Map<String, Object> indexMap, Long expireAfter, TimeUnit timeUnit) {
        this.createCollection(mongoTemplate, collectionName);
        if (MapUtils.isNotEmpty(indexMap)) {
            this.createIndex(mongoTemplate, collectionName, indexMap, expireAfter, timeUnit);
        }
    }

    protected void createCollection(MongoTemplate mongoTemplate, String collectionName) {
        if (this.existCollections.contains(collectionName)) {
            return;
        }
        if (mongoTemplate.collectionExists(collectionName)) {
            this.existCollections.put(collectionName, "1");
            return;
        }
        mongoTemplate.createCollection(collectionName);
        this.existCollections.put(collectionName, "1");
    }

    protected void createIndex(MongoTemplate mongoTemplate, String collectionName, Map<String, Object> indexMap, Long expireAfter, TimeUnit timeUnit) {
        String indexName = StringUtils.join(indexMap.keySet(), (char)'_');
        IndexOptions indexOptions = new IndexOptions().unique(true).background(true).name(indexName);
        if (null != expireAfter) {
            indexOptions.expireAfter(expireAfter, timeUnit);
        }
        mongoTemplate.getCollection(collectionName).createIndex((Bson)new Document(indexMap), indexOptions);
        indexOptions = new IndexOptions();
        indexOptions.background(true);
        mongoTemplate.getCollection(collectionName).createIndex((Bson)new Document(Collections.singletonMap("timestamp", -1)), indexOptions);
    }
}

