/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.infrastructure.mongo;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserGridPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.mongo.QueryUserDefinedMapper;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class UserDefinedMongoMapper {
    @Resource
    private QueryUserDefinedMapper queryUserDefinedMapper;
    private String PURPOSE_FIELDSEQBYUSER = "FieldSeqByUser";
    private String PURPOSE_ORDERCONDITIONS = "OrderConditions";
    private String PURPOSE_SEARCH_CONDITIONS = "SearchConditions";
    private String COLLECTION_NAME = "user_defined_center";
    private String SHRINK_NAME = "user_shrink_center";
    private String GRID_COLLECTION_NAME = "user_grid_items";

    public MongoTemplate getUserDefinedMongoTemplate() {
        return this.queryUserDefinedMapper.getUserdefinedMongoTemplate();
    }

    public void save(UserDefinedPO userDefined) {
        userDefined.setPurpose(this.PURPOSE_FIELDSEQBYUSER);
        UserDefinedPO getOneCheck = this.getFieldSeqList(userDefined);
        if (getOneCheck != null && getOneCheck.getMetadataTags() != null) {
            Query query = this.getQueryByUniqueId(getOneCheck);
            Update update = new Update();
            update.set("metadataTags", (Object)userDefined.getMetadataTags());
            update.set("updateDate", (Object)LocalDateTime.now());
            this.queryUserDefinedMapper.getUserdefinedMongoTemplate().upsert(query, (UpdateDefinition)update, this.COLLECTION_NAME);
        } else {
            userDefined.setCreateDate(LocalDateTime.now());
            userDefined.setUniqueId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
            userDefined.setPurpose(this.PURPOSE_FIELDSEQBYUSER);
            BulkOperations operations = this.queryUserDefinedMapper.getUserdefinedMongoTemplate().bulkOps(BulkOperations.BulkMode.UNORDERED, this.COLLECTION_NAME);
            operations.insert((Object)userDefined);
            operations.execute();
        }
    }

    public UserDefinedPO getFieldSeqList(UserDefinedPO userDefined) {
        List list;
        Query query = this.getQuery(userDefined);
        if (StringUtils.isNotEmpty((CharSequence)userDefined.getTableSchema())) {
            query = this.getQueryInTable(userDefined);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.queryUserDefinedMapper.getUserdefinedMongoTemplate().find(query, UserDefinedPO.class, this.COLLECTION_NAME))) && list.size() > 0) {
            UserDefinedPO userDefinedNew = (UserDefinedPO)list.get(0);
            if (CollectionUtils.isNotEmpty((Collection)userDefinedNew.getMetadataTags())) {
                userDefinedNew.getMetadataTags().stream().forEach(tag -> tag.setTableSchema(userDefinedNew.getTableSchema()));
            }
            if (this.PURPOSE_FIELDSEQBYUSER.equals(userDefined.getPurpose())) {
                if (list.size() > 1) {
                    for (int i = 1; i < list.size(); ++i) {
                        if (CollectionUtils.isNotEmpty((Collection)((UserDefinedPO)list.get(i)).getMetadataTags())) {
                            int finalI = i;
                            ((UserDefinedPO)list.get(i)).getMetadataTags().stream().forEach(tag -> tag.setTableSchema(((UserDefinedPO)list.get(finalI)).getTableSchema()));
                        }
                        userDefinedNew.getMetadataTags().addAll(((UserDefinedPO)list.get(i)).getMetadataTags());
                    }
                }
            } else if (StringUtils.isNotEmpty((CharSequence)userDefinedNew.getTableSchema())) {
                JSONObject settingWithTable = new JSONObject();
                settingWithTable.put((Object)userDefinedNew.getTableSchema(), (Object)userDefinedNew.getSettings());
                userDefinedNew.setSettings(settingWithTable);
                if (list.size() > 1) {
                    for (int i = 1; i < list.size(); ++i) {
                        UserDefinedPO oneUserDefined = (UserDefinedPO)list.get(i);
                        if (!StringUtils.isNotEmpty((CharSequence)oneUserDefined.getTableSchema())) continue;
                        settingWithTable.put((Object)oneUserDefined.getTableSchema(), (Object)oneUserDefined.getSettings());
                    }
                }
            } else if (list.size() > 1) {
                JSONArray options = userDefinedNew.getSettings().getJSONObject("order").getJSONArray("options");
                for (int i = 1; i < list.size(); ++i) {
                    options.addAll((Collection)((UserDefinedPO)list.get(i)).getSettings().getJSONObject("order").getJSONArray("options"));
                }
            }
            return userDefinedNew;
        }
        return new UserDefinedPO();
    }

    public void remove(UserDefinedPO userDefined) {
        Query query = this.getQuery(userDefined);
        if (StringUtils.isNotEmpty((CharSequence)userDefined.getTableSchema())) {
            query = this.getQueryInTable(userDefined);
        }
        this.queryUserDefinedMapper.getUserdefinedMongoTemplate().remove(query, this.COLLECTION_NAME);
    }

    private Query getQuery(UserDefinedPO userDefined) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"purpose").is((Object)userDefined.getPurpose()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userDefined.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userDefined.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageCode").is((Object)userDefined.getPageCode()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmProjectId").is((Object)userDefined.getTmProjectId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)userDefined.getTmActivityId()));
        if (StringUtils.isNotBlank((CharSequence)userDefined.getPageUniqueCode())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageUniqueCode").is((Object)userDefined.getPageUniqueCode()));
        }
        return query;
    }

    private Query getQueryInTable(UserDefinedPO userDefined) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"purpose").is((Object)userDefined.getPurpose()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tableSchema").is((Object)userDefined.getTableSchema()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userDefined.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userDefined.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageCode").is((Object)userDefined.getPageCode()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmProjectId").is((Object)userDefined.getTmProjectId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)userDefined.getTmActivityId()));
        return query;
    }

    private Query getQueryByUniqueId(UserDefinedPO userDefined) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"uniqueId").is((Object)userDefined.getUniqueId()));
        return query;
    }

    public void saveOrderConditions(UserDefinedPO userDefined) {
        userDefined.setPurpose(this.PURPOSE_ORDERCONDITIONS);
        UserDefinedPO getOneCheck = this.getFieldSeqList(userDefined);
        if (getOneCheck != null && getOneCheck.getSettings() != null) {
            Query query = this.getQueryByUniqueId(getOneCheck);
            Update update = new Update();
            update.set("settings", (Object)userDefined.getSettings());
            update.set("updateDate", (Object)LocalDateTime.now());
            this.queryUserDefinedMapper.getUserdefinedMongoTemplate().upsert(query, (UpdateDefinition)update, this.COLLECTION_NAME);
        } else {
            userDefined.setCreateDate(LocalDateTime.now());
            userDefined.setUniqueId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
            userDefined.setPurpose(this.PURPOSE_ORDERCONDITIONS);
            BulkOperations operations = this.queryUserDefinedMapper.getUserdefinedMongoTemplate().bulkOps(BulkOperations.BulkMode.UNORDERED, this.COLLECTION_NAME);
            operations.insert((Object)userDefined);
            operations.execute();
        }
    }

    public Long saveSearchConditions(UserDefinedPO userDefined) {
        userDefined.setPurpose(this.PURPOSE_SEARCH_CONDITIONS);
        userDefined.setCreateDate(LocalDateTime.now());
        userDefined.setUniqueId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        BulkOperations operations = this.queryUserDefinedMapper.getUserdefinedMongoTemplate().bulkOps(BulkOperations.BulkMode.UNORDERED, this.COLLECTION_NAME);
        operations.insert((Object)userDefined);
        operations.execute();
        return userDefined.getUniqueId();
    }

    public List<UserDefinedPO> getSearchConditions(UserDefinedPO userDefined) {
        return this.queryUserDefinedMapper.getSearchConditions(userDefined);
    }

    public void delSearchConditions(AuthoredUser user, Long uniqueId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"purpose").is((Object)this.PURPOSE_SEARCH_CONDITIONS));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)user.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"uniqueId").is((Object)uniqueId));
        this.queryUserDefinedMapper.getUserdefinedMongoTemplate().remove(query, this.COLLECTION_NAME);
    }

    public UserDefinedPO getUserShrink(UserDefinedPO userDefined) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userDefined.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userDefined.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)userDefined.getTmActivityId()));
        List list = this.queryUserDefinedMapper.getUserdefinedMongoTemplate().find(query, UserDefinedPO.class, this.SHRINK_NAME);
        if (list.size() > 0) {
            return (UserDefinedPO)list.get(0);
        }
        return new UserDefinedPO();
    }

    public void saveUserShrink(UserDefinedPO userDefined) {
        UserDefinedPO getOneCheck = this.getUserShrink(userDefined);
        if (getOneCheck != null && getOneCheck.getSettings() != null) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userDefined.getUserId()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userDefined.getTenantId()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)userDefined.getTmActivityId()));
            Update update = new Update();
            update.set("settings", (Object)userDefined.getSettings());
            update.set("updateDate", (Object)LocalDateTime.now());
            this.queryUserDefinedMapper.getUserdefinedMongoTemplate().upsert(query, (UpdateDefinition)update, this.SHRINK_NAME);
        } else {
            userDefined.setCreateDate(LocalDateTime.now());
            userDefined.setUniqueId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
            BulkOperations operations = this.queryUserDefinedMapper.getUserdefinedMongoTemplate().bulkOps(BulkOperations.BulkMode.UNORDERED, this.SHRINK_NAME);
            operations.insert((Object)userDefined);
            operations.execute();
        }
    }

    public void saveGridItems(UserGridPO userGridPO) {
        UserGridPO getOneCheck = this.queryUserDefinedMapper.getUserGrid(userGridPO);
        if (getOneCheck != null && getOneCheck.getItems() != null) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)userGridPO.getCode()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userGridPO.getTenantId()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userGridPO.getUserId()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageCode").is((Object)userGridPO.getPageCode()));
            Update update = new Update();
            update.set("items", (Object)userGridPO.getItems());
            update.set("updateDate", (Object)LocalDateTime.now());
            this.queryUserDefinedMapper.getUserdefinedMongoTemplate().upsert(query, (UpdateDefinition)update, this.GRID_COLLECTION_NAME);
        } else {
            userGridPO.setCreateDate(LocalDateTime.now());
            userGridPO.setUniqueId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
            BulkOperations operations = this.queryUserDefinedMapper.getUserdefinedMongoTemplate().bulkOps(BulkOperations.BulkMode.UNORDERED, this.GRID_COLLECTION_NAME);
            operations.insert((Object)userGridPO);
            operations.execute();
        }
    }

    public void delGridByUniqueId(Long id, AuthoredUser user) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)user.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"uniqueId").is((Object)id));
        this.queryUserDefinedMapper.getUserdefinedMongoTemplate().remove(query, this.GRID_COLLECTION_NAME);
    }
}

