package com.digiwin.athena.base.infrastructure.manager.atmc;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.NoticeProxyInfoDTO;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.VerifyAppPermissionReq;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.VerifyAppPermissionDTO;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * AtmcServiceImpl Description
 *
 * @author majianfu
 * @date 2021/8/28
 * @since
 */
@Slf4j
@Service
public class BaseAtmcServiceImpl implements BaseAtmcService {
    private static final String VERIFY_APP_PERMISSION = "/api/atmc/v1/permission/external/verifyAppPermission";

    public static final String CONFIG = "api/atmc/v1/config/operationConfig";

    public static final String GROUP_DIMENSION = "/api/atmc/v1/backlog/group/dimension";

    public static final String IS_TEST_TENANT = "/api/atmc/v1/tenant/isTest";

    public static final String MESSAGE_AGENT_CHANGE = "/api/atmc/v1/message/agent/change";

    public static final String MESSAGE_AGENT_CHANGE_BATCH = "/api/atmc/v1/proxy/notice/sendMessage";

    public static final String MESSAGE_AGENT_CLEAR = "/api/atmc/v1/message/agent/clear";

    @Resource
    private RestTemplate restTemplate;

    @Value("${atmc.uri:}")
    private String atmcUri;

    @Override
    public List<VerifyAppPermissionDTO> verifyAppPermission(VerifyAppPermissionReq verifyAppPermissionReq) {

        String url = atmcUri + VERIFY_APP_PERMISSION;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(BeanUtil.beanToMap(verifyAppPermissionReq), headers);
        ResponseEntity<BaseResultDTO<List<VerifyAppPermissionDTO>>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<VerifyAppPermissionDTO>>>() {
        });
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public Boolean verifyConfig(String configName, String name) {
        String url = atmcUri + CONFIG;
        Map<String, Object> params = new HashMap<>();
        params.put("name", name);
        params.put("configName", configName);
        params.put("operation", 0);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(BeanUtil.beanToMap(params), headers);
        ResponseEntity<BaseResultDTO<Boolean>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Boolean>>() {
        });

        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public JSONArray getGroupDimension() {
        String url = atmcUri + GROUP_DIMENSION;
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        log.info("[recommend-{}-{}][{} Recommend] invoke ATMC to get project list, url = {}", authoredUser.getUserId(), authoredUser.getTenantId(), "PROJECT", url);
        ResponseEntity<BaseResultDTO<JSONArray>> respEntity = restTemplate.exchange(url, HttpMethod.GET, null,
                new ParameterizedTypeReference<BaseResultDTO<JSONArray>>() {
                });
        log.info("[recommend-{}-{}][{} Recommend] invoke ATMC to get project list, status={}, body = {}",
                authoredUser.getUserId(), authoredUser.getTenantId(), "PROJECT", respEntity.getStatusCodeValue(), JsonUtils.objectToString(respEntity.getBody()));
        return respEntity.getBody().getResponseWithException("");
    }

    /**
     * 发送工作提醒(保存代理信息)
     *
     * @param param
     * @param token
     */
    @Override
    public void messageAgentChange(Map<String, Object> param, String token) {
        String url = atmcUri + MESSAGE_AGENT_CHANGE;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);

        try {
            log.info(MESSAGE_AGENT_CHANGE + "request param", JsonUtils.objectToString(param));
            HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            log.info(MESSAGE_AGENT_CHANGE + "response", JsonUtils.objectToString(responseEntity));
            if (Objects.isNull(responseEntity) || Objects.isNull(responseEntity.getBody())
                    || !StringUtils.equals(String.valueOf(responseEntity.getBody().getStatus()), String.valueOf(HttpStatus.SC_OK))) {
                throw BusinessException.create(AudcErrorCodeEnum.ATMC_V1_MESSAGE_AGENT_CHANGE.getErrCode(), "request atmc changeAgentSetting error");
            }
        } catch (Exception ex) {
            log.error("request atmc changeAgentSetting error", ex);
        }
    }

    /**
     * 发送工作提醒(清除代理信息)
     *
     * @param userId
     * @param token
     */
    @Override
    public void messageAgentClear(String userId, String token) {
        String url = atmcUri + MESSAGE_AGENT_CLEAR;

        Map<String, Object> param = new HashMap<>();
        param.put("userId", userId);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);

        try {
            log.info(MESSAGE_AGENT_CLEAR + "request param", JsonUtils.objectToString(param));
            HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            log.info(MESSAGE_AGENT_CLEAR + "response", JsonUtils.objectToString(responseEntity));
            if (Objects.isNull(responseEntity) || Objects.isNull(responseEntity.getBody())
                    || !StringUtils.equals(String.valueOf(responseEntity.getBody().getStatus()), String.valueOf(HttpStatus.SC_OK))) {
                throw BusinessException.create(AudcErrorCodeEnum.ATMC_V1_MESSAGE_AGENT_CLEAR.getErrCode(), "request atmc changeAgentSetting error");
            }
        } catch (Exception ex) {
            log.error("request atmc clearAgentSetting error", ex);
        }
    }

    /**
     * 批量发送消息提醒
     *
     * @param list
     * @param token
     */
    @Override
    public void messageAgentBatchChange(List<NoticeProxyInfoDTO> list, String token) {
        String url = atmcUri + MESSAGE_AGENT_CHANGE_BATCH;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);

        try {
            log.info(MESSAGE_AGENT_CHANGE_BATCH + "request param", JsonUtils.objectToString(list));
            HttpEntity<?> httpEntity = new HttpEntity<>(JsonUtils.objectToString(list), headers);
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            log.info(MESSAGE_AGENT_CHANGE_BATCH + "response", JsonUtils.objectToString(responseEntity));
            if (Objects.isNull(responseEntity) || Objects.isNull(responseEntity.getBody())
                    || !StringUtils.equals(String.valueOf(responseEntity.getBody().getStatus()), String.valueOf(HttpStatus.SC_OK))) {
                throw BusinessException.create(AudcErrorCodeEnum.ATMC_V1_MESSAGE_AGENT_CHANGE.getErrCode(), "request atmc changeAgentSetting error");
            }
        } catch (Exception ex) {
            log.error("request atmc changeAgentSetting error", ex);
        }
    }
}
