package com.digiwin.athena.base.infrastructure.meta.po.commonused;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2022/02/09 09:31:34
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "common_menu_top")
public class MenuTopData extends BaseEntity<MenuTopData> implements Serializable {
    @TableId()
    private Long id;

    /**
     * 模块编号baseEntry：基础资料，report：报表 guess:猜你想去 后续有新增则依次递增
     */
    private String moduleNo;

    /**
     * 用户id
     */
    private String userId;
    /**
     * 租户id
     */

    private String tenantId;
//    /**
//     * 用户名称
//     */
//    private String userName;
    /**
     * 是否置顶 0：非置顶 1：置顶
     */
    private Integer isTop;
}

