package com.digiwin.athena.base.infrastructure.meta.po.trial;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/06 09:19:21
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "trial_user_scene")
public class TrialUserSceneData extends BaseEntity<TrialUserSceneData> implements Serializable {

    @TableId()
    private Long id;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 角色id
     */
    private String roleId;
    /**
     * 角色名称
     */
    private String roleName;
    /**
     * 应用编码
     */
    private String appCode;
    /**
     * 场景id
     */
    private Long sceneId;

    private String sceneKey;
    /**
     * 排序
     */
    @TableField("`rank`")
    private Integer rank;
}
