package com.digiwin.athena.base.infrastructure.util;

import com.digiwin.athena.appcore.util.CollectibleDocumentFieldNameValidator;
import org.apache.commons.collections4.MapUtils;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/**
 * DataFilterUtils Description
 *
 * @author majianfu
 * @date 2022/5/9
 * @since
 */
public abstract class DataFilterUtils {
    private DataFilterUtils() {
    }

    /**
     * 去除不符合mongo命名规范的字段
     *
     * @param data
     */
    public static void removeMongoIllegalNameField(Object data) {
        if (null == data) {
            return;
        }
        // Map类型
        else if (Map.class.isAssignableFrom(data.getClass())) {
            removeMapIllegalKeyNameEntry((Map) data);
        }
        // 集合类型
        else if (Collection.class.isAssignableFrom(data.getClass())) {
            Collection collection = (Collection) data;
            for (Object element : collection) {
                removeMongoIllegalNameField(element);
            }
        }
        // 数组类型
        else if (data.getClass().isArray()) {
            Object[] array = (Object[]) data;
            for (int idx = 0; idx < array.length; idx++) {
                removeMongoIllegalNameField(array[idx]);
            }
        }
        // 其他类型不需要过滤非法key，因为其他类型要么是基本数据类型，要么是自定义的Object类型（key的名称是固定的）
    }

    private static void removeMapIllegalKeyNameEntry(Map data) {
        if (MapUtils.isEmpty(data)) {
            return;
        }

        Iterator iterator = data.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            // String类型的key
            if (key instanceof String) {
                String keyName = key.toString();
                // 使用mongo document的校验规则，校验fieldName
                boolean isValid = new CollectibleDocumentFieldNameValidator().validate(keyName);
                if (isValid) {
                    Object value = data.get(key);
                    // Map/集合/数组 才需要递归分析
                    if (null != value && (Map.class.isAssignableFrom(value.getClass()) || Collection.class.isAssignableFrom(value.getClass()) || value.getClass().isArray())) {
                        removeMongoIllegalNameField(value);
                    }
                } else {
                    data.remove(key);
                }
            }
        }
    }
}
