package com.digiwin.athena.base.presentation.server.web;

import cn.hutool.json.JSONUtil;
import com.digiwin.athena.atdm.config.ThreadPoolDetailInfo;
import com.digiwin.athena.atdm.config.ThreadPoolMonitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

/**
 **/
@RestController
@RequestMapping(value = "api/atdm/env")
public class ThreadPoolController {

    @Autowired
    private ExecutorService executorService;

    @Resource
    private ServerProperties serverProperties;

    @GetMapping(value = "/getThreadPoolListInfo")
    private List<ThreadPoolDetailInfo> getThreadPoolListInfo() {
        List<ThreadPoolDetailInfo> detailInfoList = new ArrayList();
        ThreadPoolDetailInfo threadPoolDetailInfo = this.threadPoolInfo((ThreadPoolMonitor) executorService, "");
        detailInfoList.add(threadPoolDetailInfo);
        return detailInfoList;
    }

    @GetMapping(value = "/getServerProperties")
    public String getServerProperties() {
        return JSONUtil.toJsonPrettyStr(serverProperties);
    }

    private ThreadPoolDetailInfo threadPoolInfo(ThreadPoolMonitor threadPool, String threadPoolName) {
        BigDecimal activeCount = new BigDecimal(threadPool.getActiveCount());
        BigDecimal maximumPoolSize = new BigDecimal(threadPool.getMaximumPoolSize());
        BigDecimal result = activeCount.divide(maximumPoolSize, 2, 4);
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        int queueCapacity =  threadPool.getQueueCapacity();
        return new ThreadPoolDetailInfo(threadPoolName, threadPool.getPoolSize(), threadPool.getCorePoolSize(), threadPool.getLargestPoolSize(), threadPool.getMaximumPoolSize(), threadPool.getCompletedTaskCount(), threadPool.getActiveCount(), threadPool.getTaskCount(), threadPool.getKeepAliveTime(TimeUnit.MILLISECONDS), (int)result.doubleValue() * 100, queueCapacity, threadPool.getQueue().size(), threadPool.getTaskCount() == 0L ? 0L : threadPool.getTotalDiff() / threadPool.getTaskCount());
    }
}