/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.guide;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.guide.UserGuidePoJo;
import com.digiwin.athena.base.application.meta.response.guide.UserGuideResult;
import com.digiwin.athena.base.application.service.guide.UserGuideService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/guide"})
public class UserGuideController {
    private static final Logger log = LoggerFactory.getLogger(UserGuideController.class);
    private static final int GUIDE_STATE_DISABLE = 1;
    private final UserGuideService userGuideService;

    @Autowired
    public UserGuideController(UserGuideService userGuideService) {
        this.userGuideService = userGuideService;
    }

    @GetMapping(value={"/call", "/open/call"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> call(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="modularCode") String modularCode, @RequestParam(value="code") String code, @RequestParam(value="appCode") String appCode, @RequestParam(value="subKey") String subKey) {
        UserGuidePoJo pojo = this.packagePojo(user, modularCode, code, appCode, null, subKey);
        UserGuideResult result = new UserGuideResult();
        try {
            result = this.userGuideService.queryGuideInfo(pojo);
        }
        catch (BusinessException e) {
            result.setRetCode(e.getCode());
            result.setRetDesc(e.getMessage());
        }
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/disable"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> disableGuideInfo(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="modularCode") String modularCode, @RequestParam(value="code") String code, @RequestParam(value="appCode") String appCode, @RequestParam(value="subKey") String subKey) {
        UserGuideResult retInfo = new UserGuideResult();
        UserGuidePoJo pojo = this.packagePojo(user, modularCode, code, appCode, Integer.valueOf(1), subKey);
        try {
            retInfo = this.userGuideService.disableGuideInfo(pojo);
        }
        catch (BusinessException e) {
            retInfo.setRetCode(e.getCode());
            retInfo.setRetDesc(e.getMessage());
        }
        return ResponseEntityWrapper.wrapperOk((Object)retInfo);
    }

    @GetMapping(value={"/reset"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> disableGuideInfo(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        UserGuideResult retInfo = new UserGuideResult();
        try {
            retInfo = this.userGuideService.resetUserGuideInfo(user.getUserId());
        }
        catch (BusinessException e) {
            retInfo.setRetCode(e.getCode());
            retInfo.setRetDesc(e.getMessage());
        }
        return ResponseEntityWrapper.wrapperOk((Object)retInfo);
    }

    private UserGuidePoJo packagePojo(AuthoredUser user, String modularCode, String code, String appCode, Integer state, String subKey) {
        UserGuidePoJo pojo = new UserGuidePoJo();
        pojo.setUserId(user.getUserId());
        pojo.setTenantId(user.getTenantId());
        pojo.setModularCode(modularCode);
        pojo.setCode(code);
        pojo.setAppCode(appCode);
        pojo.setState(state);
        pojo.setSubKey(subKey);
        return pojo;
    }
}

