/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.trial;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.service.trial.TrialSceneService;
import com.digiwin.athena.base.application.util.FileUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/trial/data"})
public class TrialImportController {
    private static final Logger log = LoggerFactory.getLogger(TrialImportController.class);
    private final TrialSceneService trialSceneService;
    private static final Logger logger = LoggerFactory.getLogger(TrialImportController.class);

    @Autowired
    public TrialImportController(TrialSceneService trialSceneService) {
        this.trialSceneService = trialSceneService;
    }

    @PostMapping(value={"/uploadScenes"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> uploadScene(@RequestParam(value="file") MultipartFile file) {
        String parseStr = "";
        try {
            InputStream fis = file.getInputStream();
            parseStr = FileUtils.StreamToString((InputStream)fis);
            ProcessingReport report = FileUtils.validate((String)parseStr, (String)"{\n    \"$schema\": \"http://json-schema.org/draft-04/schema#\",\n    \"type\": \"object\",\n    \"properties\": {\n        \"key\": {\n            \"type\": \"string\"\n        },\n        \"appCode\": {\n            \"type\": \"string\"\n        },\n        \"roleName\": {\n            \"type\": \"string\"\n        },\n        \"highlight\": {\n            \"type\": \"string\"\n        },\n        \"title\": {\n            \"type\": \"string\"\n        },\n        \"description\": {\n            \"type\": \"string\"\n        },\n        \"entry\": {\n            \"type\": \"string\"\n        },\n        \"steps\": {\n            \"type\": \"array\",\n            \"items\": {\n                \"type\": \"object\",\n                \"properties\": {\n                    \"selector\": {\n                        \"type\": [\n                            \"string\",\n                            \"object\"\n                        ],\n                        \"properties\": {\n                            \"type\": {\n                                \"type\": \"string\"\n                            },\n                            \"projectNo\": {\n                                \"type\": \"string\"\n                            },\n                            \"projectName\": {\n                                \"type\": \"string\"\n                            }\n                        },\n                        \"additionalProperties\": false\n                    },\n                    \"tooltip\": {\n                        \"type\": \"object\",\n                        \"properties\": {\n                            \"text\": {\n                                \"type\": \"string\"\n                            },\n                            \"highlight\": {\n                                \"type\": \"string\"\n                            },\n                            \"placement\": {\n                                \"type\": \"string\"\n                            }\n                        },\n                        \"additionalProperties\": false,\n                        \"required\": [\n                            \"text\"\n                        ]\n                    },\n                    \"enterNextStep\": {\n                        \"type\": \"string\"\n                    },\n                    \"cacheValue\": {\n                        \"type\": \"boolean\"\n                    },\n                    \"modal\": {\n                        \"type\": \"object\",\n                        \"properties\": {\n                            \"text\": {\n                                \"type\": \"string\"\n                            },\n                            \"suppressNextButton\": {\n                                \"type\": \"boolean\"\n                            },\n                            \"autoClose\": {\n                                \"type\": \"boolean\"\n                            }\n                        },\n                        \"additionalProperties\": false,\n                        \"required\": [\n                            \"text\"\n                        ]\n                    },\n                    \"delay\": {\n                        \"type\": \"integer\"\n                    }\n                },\n                \"additionalProperties\": false\n            },\n            \"additionalItems\": false\n        }\n    },\n    \"additionalProperties\": false,\n    \"required\": [\n        \"key\",\n        \"appCode\",\n        \"roleName\",\n        \"highlight\",\n        \"title\",\n        \"description\",\n        \"entry\",\n        \"steps\"\n    ]\n}");
            if (!report.isSuccess()) {
                ArrayList<JsonNode> list = new ArrayList<JsonNode>();
                for (ProcessingMessage message : report) {
                    list.add(message.asJson());
                }
                return ResponseEntityWrapper.wrapperOk(list);
            }
        }
        catch (IOException e) {
            logger.error("Parse Upload File error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)("Parse Upload File error." + e.getMessage()));
        }
        try {
            JSONObject sceneObj = (JSONObject)JsonUtils.jsonToObject((String)parseStr, JSONObject.class);
            if (sceneObj.containsKey((Object)"key")) {
                String sceneKey = sceneObj.getString("key");
                boolean sceneKeyExist = this.trialSceneService.isSceneExist(sceneKey);
                if (!sceneKeyExist) {
                    return ResponseEntityWrapper.wrapperFail((int)-1, (String)"Maintenance Scenario Key First");
                }
                int updateResult = this.trialSceneService.updateDetail(sceneKey, parseStr);
                return ResponseEntityWrapper.wrapperOk((Object)updateResult);
            }
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"Key information missing");
        }
        catch (Exception e) {
            logger.error("Parse Upload File Content error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)("Parse Upload Content error." + e.getMessage()));
        }
    }
}

