package com.digiwin.athena.base.presentation.server.web.trial;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrailUserSceneBindReq;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrialUserSceneReq;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrialUserSceneResp;
import com.digiwin.athena.base.application.service.trial.TrialUserSceneService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 描述
 * 用户场景
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/03 17:18:37
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/trial/userScene")
public class TrialUserSceneController {

    private final TrialUserSceneService trialUserSceneService;

    /**
     * 构造函数注入对象
     *
     * @param trialUserSceneService trialUserSceneService
     */
    public TrialUserSceneController(TrialUserSceneService trialUserSceneService) {
        this.trialUserSceneService = trialUserSceneService;
    }

    /**
     * 修改场景
     *
     * @return ResponseEntity
     */
    @PostMapping(value = "/modify", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> modify(@RequestBody TrialUserSceneReq req) {
        int result = trialUserSceneService.modify(req);
        return ResponseEntityWrapper.wrapperOk(result);
    }

    /**
     * 删除场景
     *
     * @return ResponseEntity
     */
    @GetMapping(value = "/delete/{id}", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> delete(@PathVariable("id") long id) {
        int result = trialUserSceneService.delete(id);
        return ResponseEntityWrapper.wrapperOk(result);
    }


    /**
     * 用户与场景绑定
     *
     * @return ResponseEntity
     */
    @PostMapping(value = "/bindScenes", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> bindScenes(@RequestBody TrailUserSceneBindReq req) {
        trialUserSceneService.bindScenes(req);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 查询场景场景以及场景绑定的步骤列表
     *
     * @return ResponseEntity
     */
    @GetMapping(value = "/queryWithScenes", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> queryWithScenes(@RequestParam(value = "userId") String userId,
                                             @RequestParam(value = "tenantId") String tenantId,
                                             @RequestParam(value = "appCode") String appCode) {
        TrailUserSceneBindReq req = new TrailUserSceneBindReq();
        req.setUserId(userId);
        req.setTenantId(tenantId);
        req.setAppCode(appCode);
        TrialUserSceneResp resp = trialUserSceneService.listWithScenes(req);
        return ResponseEntityWrapper.wrapperOk(resp);
    }


    /**
     * 删除场景
     *
     * @return ResponseEntity
     */
    @GetMapping(value = "/deleteWithUser", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> deleteWithUser(@RequestParam(value = "userId") String userId,@RequestParam(value = "sceneId") Long sceneId) {
        int result = trialUserSceneService.deleteWithUser(userId,sceneId);
        return ResponseEntityWrapper.wrapperOk(result);
    }
}
