package com.digiwin.athena.base.presentation.server.web.principal;

import com.digiwin.app.log.JsonUtil;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.principal.TaskTypeQueryReq;
import com.digiwin.athena.base.application.service.principal.PrincipalTaskTypeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * PrincipalTaskTypeController Description
 *
 * @author chenpeng
 * @date 2024年8月26日
 * @since
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/audc/v1/the/principal")
public class PrincipalTaskTypeController {
    @Autowired
    private PrincipalTaskTypeService principalTaskTypeService;

    /**
     * 查询被代理人可被代理的任务类型
     *
     * @param user
     * @param taskTypeQueryReq
     * @return
     */
    @PostMapping("/taskDefCodes/query")
    public ResponseEntity<?> queryTaskType(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user,
                                           @RequestBody TaskTypeQueryReq taskTypeQueryReq) {
        log.info("queryTaskType request param :{}", JsonUtil.toString(taskTypeQueryReq));
        return ResponseEntityWrapper.wrapperOk(principalTaskTypeService.queryTaskType(taskTypeQueryReq, user.getTenantId()));
    }
}
