package com.digiwin.athena.base.presentation.server.web.usertrack;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.usertrack.AccountDTO;
import com.digiwin.athena.base.application.meta.request.usertrack.UserTrackSearchDTO;
import com.digiwin.athena.base.application.service.usertrack.UserTrackService;
import com.digiwin.athena.base.infrastructure.meta.po.usertrack.mongo.UserTrackExtendDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 用户行为轨迹 Controller
 *
 * @author majfa
 * @date 2021/08/27
 * @since [迭代19]
 */
@RestController
@RequestMapping(value = "/api/v1/user/track")
public class UserTrackController {
    @Autowired
    private UserTrackService userTrackService;

    /**
     * 上报用户行为轨迹信息
     *
     * @param userTrackList 用户行为轨迹上报信息
     * @return
     */
    @PostMapping("/report")
    public ResponseEntity<?> reportUserTrack(@RequestBody List<UserTrackExtendDTO> userTrackList) {
        userTrackService.handleReportData(userTrackList);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 清除上报数据
     *
     * @return
     */
    @PostMapping("/clear")
    public ResponseEntity<?> clearReportData(@RequestBody AccountDTO account) {
        userTrackService.clearReportData(account);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 根据参数查询埋点数据
     *
     * @param userTrackSearchDTO
     * @return
     */
    @PostMapping("/search")
    public ResponseEntity<?> findByParam(@RequestBody UserTrackSearchDTO userTrackSearchDTO, @RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(userTrackService.findByParam(userTrackSearchDTO, user));
    }
}
