/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.proxyinfo;

import com.digiwin.app.log.JsonUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoRemoveReq;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoSaveReq;
import com.digiwin.athena.base.application.meta.request.proxyinfo.SaveSubordinateReq;
import com.digiwin.athena.base.application.service.proxyinfo.ProxyInfoService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/audc/v1/proxy/info"})
public class ProxyInfoController {
    private static final Logger log = LoggerFactory.getLogger(ProxyInfoController.class);
    @Autowired
    private ProxyInfoService proxyInfoService;

    @PostMapping(value={"/save"})
    public ResponseEntity<?> saveProxyInfo(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody ProxyInfoSaveReq proxyInfoSaveReq) {
        log.info("saveProxyInfo request param :{}", (Object)JsonUtil.toString((Object)proxyInfoSaveReq));
        this.proxyInfoService.saveProxyInfo(proxyInfoSaveReq, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/remove"})
    public ResponseEntity<?> removeProxyInfo(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody ProxyInfoRemoveReq proxyInfoRemoveReq) {
        log.info("removeProxyInfo request param :{}", (Object)JsonUtil.toString((Object)proxyInfoRemoveReq));
        this.proxyInfoService.removeProxyInfo(proxyInfoRemoveReq, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/subordinate/query"})
    public ResponseEntity<?> querySubordinate(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        List resultList = this.proxyInfoService.querySubordinate(user);
        return ResponseEntityWrapper.wrapperOk((Object)resultList);
    }

    @PostMapping(value={"/subordinate/save"})
    public ResponseEntity<?> saveSubordinate(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody SaveSubordinateReq saveSubordinateReq) {
        log.info("saveSubordinate request param :{}", (Object)JsonUtil.toString((Object)saveSubordinateReq));
        this.proxyInfoService.saveSubordinate(saveSubordinateReq, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/subordinate/remove"})
    public ResponseEntity<?> removeSubordinate(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody ProxyInfoRemoveReq proxyInfoRemoveReq) {
        log.info("removeSubordinate request param :{}", (Object)JsonUtil.toString((Object)proxyInfoRemoveReq));
        this.proxyInfoService.removeSubordinate(proxyInfoRemoveReq, user);
        return ResponseEntityWrapper.wrapperOk();
    }
}

