package com.digiwin.athena.base.presentation.server.web.action;


import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.atdm.action.executor.DataSubmissionServiceWrapper;
import com.digiwin.athena.atdm.activity.domain.MergeSubmitActionDTO;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Slf4j
@RestController
@RequestMapping(value = "/api/atdm/v1/action/")
public class ActionExecuteController {
    @Autowired
    private DataSubmissionServiceWrapper dataSubmissionServiceWrapper;

    /**
     * 提交数据
     */
    @PostMapping(value = {"/submit/task", "/open/submit/task"}, produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> executeAction(HttpServletRequest request, @RequestBody SubmitActionDTO submitAction) {
        return ResponseEntityWrapper.wrapperOk(dataSubmissionServiceWrapper.executeAction(request, submitAction));
    }

    /**
     * 仅执行action
     * <br>不会判断是否处理完成
     * <br>不会关闭待办等
     */
    @PostMapping(value = {"/execute", "/open/execute"}, produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> executeOpenTaskWindowAction(HttpServletRequest request, @RequestBody SubmitActionDTO submitAction) {
        return ResponseEntityWrapper.wrapperOk(dataSubmissionServiceWrapper.executeOpenTaskWindowAction(request, submitAction));
    }

    /**
     * 项目卡退回接口
     */
    @PostMapping(value = "/submit/returnTask", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> executeReturnAction(HttpServletRequest request, @RequestBody List<SubmitActionDTO> submitActionList) throws Throwable {
        return ResponseEntityWrapper.wrapperOk(dataSubmissionServiceWrapper.executeReturnAction(request, submitActionList));
    }

    /**
     * 提交合并任务的数据
     */
    @PostMapping(value = "/submit/mergeTask", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> executeMergeAction(HttpServletRequest request, @RequestBody List<SubmitActionDTO> submitActionList) throws Throwable {
        return ResponseEntityWrapper.wrapperOk(dataSubmissionServiceWrapper.executeMergeAction(request, submitActionList));
    }

    /**
     * 提交合并任务的数据_支持跨BK
     *
     * @return
     */
    @PostMapping(value = "/submit/mergeTaskCrossBk", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> executeMergeActionCrossBk(HttpServletRequest request, @RequestBody List<SubmitActionDTO> submitActionList) throws Throwable {
        return ResponseEntityWrapper.wrapperOk(dataSubmissionServiceWrapper.executeMergeActionCrossBk(request, submitActionList));
    }

    @PostMapping(value = "/submit/mergeTaskRetry", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> executeMergeActionRetry(HttpServletRequest request, @RequestBody MergeSubmitActionDTO mergeSubmitAction) throws Throwable {
        return ResponseEntityWrapper.wrapperOk(dataSubmissionServiceWrapper.executeMergeActionRetry(request, mergeSubmitAction));
    }
}
