#!/bin/sh

mem_jvm_heap_mb=""
mem_jvm_heap=""

if [ -n "$ja_Xms" ]; then
  mem_jvm_heap=$ja_Xms
elif [ -n "$LIMITMEMORY" ]; then
  mem_jvm_heap=$(echo $LIMITMEMORY | sed 's/MB$//')
  if [ "$mem_jvm_heap" -le 2048 ];then
    mem_jvm_heap=$((mem_jvm_heap / 2))
  else
    mem_jvm_heap=$((mem_jvm_heap - 2048))
  fi
fi

if [ -z "$mem_jvm_heap" ]; then
  echo "Error: mem_jvm_heap not set!"
  exit 1
else
  mem_jvm_heap_mb="${mem_jvm_heap}m"
fi

jvm_gc=""
if [ -z "$ja_GC" ]; then
  if [ "$mem_jvm_heap" -ge 2048 ];then
    jvm_gc="G1GC"
  else
    jvm_gc="ParallelGC"
  fi
fi

path_base=`pwd`
echo "pwd : ${path_base}"
jar_name=`ls -t *.jar | grep -v 'sources' | head -1`
echo "jar : ${jar_name}"

opts_jvm=" -server"
opts_jvm="$opts_jvm -Duser.home=${path_base}"
opts_jvm="$opts_jvm -Djava.security.egd=file:/dev/./urandom"
#opts_jvm="$opts_jvm -Djava.net.preferIPv4Stack=true"
opts_jvm="$opts_jvm -Dfile.encoding=UTF-8"
opts_jvm="$opts_jvm -DJM.LOG.PATH=${path_base}/.logs/nacos"
#opts_jvm="$opts_jvm -Duser.timezone=UTC"
#opts_jvm="$opts_jvm -Dprogram.name=${PROGRAM_NAME}"
opts_jvm="$opts_jvm -Xms${ja_Xms:-$mem_jvm_heap_mb}"
opts_jvm="$opts_jvm -Xmx${ja_Xmx:-$mem_jvm_heap_mb}"
opts_jvm="$opts_jvm -Xss${ja_Xss:-256k}"
#opts_jvm="$opts_jvm -XX:MetaspaceSize=256m"
#opts_jvm="$opts_jvm -XX:MaxMetaspaceSize=256m"
#opts_jvm="$opts_jvm -XX:NewRatio=2"
opts_jvm="$opts_jvm -XX:+HeapDumpOnOutOfMemoryError"
opts_jvm="$opts_jvm -XX:+Use${ja_GC:-$jvm_gc}"
if [ "$jvm_gc" != "G1GC" ]; then
  opts_jvm="$opts_jvm -XX:NewRatio=1"
fi
opts_jvm="$opts_jvm -XX:+PrintGCDateStamps"
opts_jvm="$opts_jvm -XX:+PrintGCDetails"
opts_jvm="$opts_jvm -XX:-OmitStackTraceInFastThrow"
opts_jvm="$opts_jvm -XX:+UseGCLogFileRotation"
opts_jvm="$opts_jvm -XX:NumberOfGCLogFiles=10"
opts_jvm="$opts_jvm -XX:GCLogFileSize=100M"
opts_jvm="$opts_jvm -XX:HeapDumpPath=${path_base}/.logs"
opts_jvm="$opts_jvm -Xloggc:${path_base}/.logs/gc.log"

if [ -n "$open_debug" ]; then
   opts_jvm="$opts_jvm -XX:NativeMemoryTracking=detail"
   opts_jvm="$opts_jvm -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=20019"
fi

echo "opts_jvm : ${opts_jvm}"

if [ -n "$ja_pinpoint_opts" ]; then
  echo "java ${ja_pinpoint_opts} ${opts_jvm} -jar ${jar_name}"
  java $ja_pinpoint_opts -jar $jar_name
else
  export AGENT_PATH=${path_base}/agent_pinpoint/pinpoint-bootstrap.jar
  export AGENT_NAME=$pinpoint_appname
  sed -i "s/profiler\.transport\.grpc\.collector\.ip=.*/profiler\.transport\.grpc\.collector\.ip=$collector_ip/g" agent_pinpoint/profiles/release/pinpoint.config
  sed -i "s/profiler\.collector\.ip=.*/profiler\.collector\.ip=$collector_ip/g" agent_pinpoint/profiles/release/pinpoint.config
  echo "collector_ip : ${collector_ip}"

  #get AGENT_ID
  nameSize=${#HOSTNAME}
  echo "HOSTNAME : ${HOSTNAME} nameSize : ${nameSize}"
  if [ $nameSize -ge 5 ] ; then
     export AGENT_ID_SUFFIX=${HOSTNAME:0-5}
  else
     export AGENT_ID_SUFFIX=$HOSTNAME
  fi
  echo "AGENT_ID_SUFFIX : ${AGENT_ID_SUFFIX}"
  echo "pinpoint_id : ${pinpoint_id}"

  if test -n "$AGENT_ID_SUFFIX" ; then
     export AGENT_ID=$pinpoint_id-$AGENT_ID_SUFFIX
  else
     export AGENT_ID=$pinpoint_id
  fi
  echo "AGENT_ID : ${AGENT_ID}"
  AGENT_OPTS="-javaagent:$AGENT_PATH -Dpinpoint.agentId=$AGENT_ID -Dpinpoint.applicationName=$AGENT_NAME"
  chmod 777 ${path_base}/agent_pinpoint

  echo "java ${AGENT_OPTS} ${opts_jvm} -jar ${jar_name}"
  java $AGENT_OPTS $opts_jvm -jar $jar_name
fi




