/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.trial;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialSceneCardMapper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/scene/back"})
public class SceneBackController {
    private static final Logger log = LoggerFactory.getLogger(SceneBackController.class);
    private final TrialSceneCardMapper trialSceneCardMapper;

    @Autowired
    public SceneBackController(TrialSceneCardMapper trialSceneCardMapper) {
        this.trialSceneCardMapper = trialSceneCardMapper;
    }

    @GetMapping(value={"/query"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> query(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestParam(value="sceneId", required=false) Long sceneId, @RequestParam(value="stepId", required=false) Long stepId) {
        if (Objects.isNull(sceneId) && Objects.isNull(stepId)) {
            return ResponseEntityWrapper.wrapperOk((Object)-1);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!Objects.isNull(sceneId)) {
            queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        }
        if (!Objects.isNull(stepId)) {
            queryWrapper.eq((Object)"step_id", (Object)stepId);
        }
        queryWrapper.eq((Object)"user_id", (Object)user.getUserId());
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        queryWrapper.orderByDesc((Object)"create_date");
        List list = this.trialSceneCardMapper.selectList((Wrapper)queryWrapper);
        if (list != null && !list.isEmpty()) {
            return ResponseEntityWrapper.wrapperOk(list.get(0));
        }
        return ResponseEntityWrapper.wrapperOk((Object)Collections.EMPTY_LIST);
    }
}

