/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.userdefined;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserDefinedCenterDTO;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserGridDTO;
import com.digiwin.athena.base.application.service.userdefined.UserDefinedService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/audc/v1/userdefined"})
public class UserDefinedActionController {
    @Autowired
    JsonConfig jsonConfig;
    @Autowired
    private UserDefinedService userDefinedService;

    @GetMapping(value={"/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}", "/open/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}"})
    ResponseEntity<?> getFieldSeqListActions(@PathVariable(value="pageCode") String pageCode, @PathVariable(value="tmProjectId") String tmProjectId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestParam(required=false) String pageUniqueCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        UserDefinedCenterDTO userDefined = this.userDefinedService.getFieldSeqList(user, pageCode, tmProjectId, tmActivityId, null, pageUniqueCode);
        if (CollectionUtils.isNotEmpty((Collection)userDefined.getMetadataTags())) {
            return ResponseEntityWrapper.wrapperOk((Object)userDefined.getMetadataTags());
        }
        return ResponseEntityWrapper.wrapperOk(new ArrayList());
    }

    @PostMapping(value={"/batch/fieldlist"})
    ResponseEntity<?> getFieldSeqListActions(@RequestBody List<String> tmActivityIdList) {
        return ResponseEntityWrapper.wrapperOk((Object)this.userDefinedService.getFieldSeqList(tmActivityIdList));
    }

    @GetMapping(value={"/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}/{tableSchema}", "/open/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}/{tableSchema}"})
    ResponseEntity<?> getFieldSeqListActionsV2(@PathVariable(value="pageCode") String pageCode, @PathVariable(value="tmProjectId") String tmProjectId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="tableSchema") String tableSchema, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        UserDefinedCenterDTO userDefined = this.userDefinedService.getFieldSeqList(user, pageCode, tmProjectId, tmActivityId, tableSchema);
        if (CollectionUtils.isNotEmpty((Collection)userDefined.getMetadataTags())) {
            return ResponseEntityWrapper.wrapperOk((Object)userDefined.getMetadataTags());
        }
        return ResponseEntityWrapper.wrapperOk(new ArrayList());
    }

    @PostMapping(value={"/save", "/open/save"})
    ResponseEntity<?> saveFieldSeqActions(@RequestBody Map fieldJson, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        JSONObject jsonObject = (JSONObject)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)fieldJson), JSONObject.class);
        this.userDefinedService.save(user, jsonObject);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/remove/{pageCode}/{tmProjectId}/{tmActivityId}/{tableSchema.*}", "/open/remove/{pageCode}/{tmProjectId}/{tmActivityId}/{tableSchema.*}"})
    ResponseEntity<?> removeFieldSeqActions(@PathVariable(value="pageCode") String pageCode, @PathVariable(value="tmProjectId") String tmProjectId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="tableSchema.*") String tableSchema, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.userDefinedService.remove(user, pageCode, tmProjectId, tmActivityId, tableSchema);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/remove/{pageCode}/{tmProjectId}/{tmActivityId}", "/open/remove/{pageCode}/{tmProjectId}/{tmActivityId}"})
    ResponseEntity<?> removeFieldSeqActions(@PathVariable(value="pageCode") String pageCode, @PathVariable(value="tmProjectId") String tmProjectId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.userDefinedService.remove(user, pageCode, tmProjectId, tmActivityId, null);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/orderconditions/save"})
    ResponseEntity<?> saveOrderConditionsActions(@RequestBody Map fieldJson, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        JSONObject jsonObject = (JSONObject)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)fieldJson), JSONObject.class);
        this.userDefinedService.saveOrderConditions(user, jsonObject);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/orderconditions/fields/{pageCode}/{tmProjectId}/{tmActivityId}"})
    ResponseEntity<?> getOrderConditionsActions(@PathVariable(value="pageCode") String pageCode, @PathVariable(value="tmProjectId") String tmProjectId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestParam(required=false) String pageUniqueCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        UserDefinedCenterDTO userDefined = this.userDefinedService.getOrderConditionsByUser(user, pageCode, tmProjectId, tmActivityId, null, pageUniqueCode);
        if (userDefined.getSettings() != null) {
            return ResponseEntityWrapper.wrapperOk((Object)userDefined.getSettings());
        }
        return ResponseEntityWrapper.wrapperOk((Object)new JSONObject());
    }

    @GetMapping(value={"/orderconditions/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}"})
    ResponseEntity<?> getOrderConditionsFileds(@PathVariable(value="pageCode") String pageCode, @PathVariable(value="tmProjectId") String tmProjectId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        List userDefined = this.userDefinedService.getOrderConditionsFields(user, pageCode, tmProjectId, tmActivityId, null);
        if (CollectionUtils.isNotEmpty(userDefined = userDefined.stream().filter(x -> x.getSettings() != null).collect(Collectors.toList()))) {
            return ResponseEntityWrapper.wrapperOk(userDefined.stream().map(defined -> defined.getSettings()).collect(Collectors.toList()));
        }
        return ResponseEntityWrapper.wrapperOk((Object)Lists.newArrayList());
    }

    @GetMapping(value={"/orderconditions/remove/{pageCode}/{tmProjectId}/{tmActivityId}"})
    ResponseEntity<?> removeOrderConditionsActions(@PathVariable(value="pageCode") String pageCode, @PathVariable(value="tmProjectId") String tmProjectId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.userDefinedService.removeOrderConditions(user, pageCode, tmProjectId, tmActivityId, null);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/orderconditions/remove/{pageCode}/{tmProjectId}/{tmActivityId}/{tableSchema.*}"})
    ResponseEntity<?> removeOrderConditionsActions(@PathVariable(value="pageCode") String pageCode, @PathVariable(value="tmProjectId") String tmProjectId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="tableSchema.*") String tableSchema, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.userDefinedService.removeOrderConditions(user, pageCode, tmProjectId, tmActivityId, tableSchema);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/userShrink/{tmActivityId}"})
    ResponseEntity<?> getUserShrink(@PathVariable(value="tmActivityId") String tmActivityId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        UserDefinedCenterDTO userDefined = this.userDefinedService.getUserShrink(user, tmActivityId);
        if (userDefined.getSettings() != null) {
            return ResponseEntityWrapper.wrapperOk((Object)userDefined.getSettings());
        }
        return ResponseEntityWrapper.wrapperOk((Object)new JSONObject());
    }

    @PostMapping(value={"/userShrink/save"})
    ResponseEntity<?> saveUserShrink(@RequestBody JSONObject fieldJson, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.userDefinedService.saveUserShrink(user, fieldJson);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/fieldArrtlist/{pageCode}/{tmProjectId}/{tmActivityId}/{table}"})
    ResponseEntity<?> getFieldArrtListActions(@PathVariable(value="pageCode") String pageCode, @PathVariable(value="tmProjectId") String tmProjectId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="table") String table, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Object userDefined = this.userDefinedService.getFieldArrtList(user, pageCode, tmProjectId, tmActivityId, table);
        return ResponseEntityWrapper.wrapperOk((Object)userDefined);
    }

    @GetMapping(value={"/fieldArrtlist/{pageCode}/{tmProjectId}/{tmActivityId}"})
    ResponseEntity<?> getFieldArrtListActions(@PathVariable(value="pageCode") String pageCode, @PathVariable(value="tmProjectId") String tmProjectId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Object userDefined = this.userDefinedService.getFieldArrtList(user, pageCode, tmProjectId, tmActivityId, null);
        return ResponseEntityWrapper.wrapperOk((Object)userDefined);
    }

    @GetMapping(value={"/searchConditions/{tmActivityId}/{pageCode}/{tableSchema}"})
    ResponseEntity<?> getSearchConditions(@PathVariable String tmActivityId, @PathVariable String pageCode, @PathVariable String tableSchema, @RequestParam(required=false) String pageUniqueCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPageCode(pageCode);
        userDefined.setTableSchema(tableSchema);
        userDefined.setPageUniqueCode(pageUniqueCode);
        return ResponseEntityWrapper.wrapperOk((Object)this.userDefinedService.getSearchConditions(user, userDefined));
    }

    @PostMapping(value={"/searchConditions/save"})
    ResponseEntity<?> saveSearchConditions(@RequestBody UserDefinedCenterDTO userDefined, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.userDefinedService.saveSearchConditions(user, userDefined));
    }

    @PostMapping(value={"/searchConditions/del/{uniqueId}"})
    ResponseEntity<?> delSearchConditions(@PathVariable Long uniqueId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.userDefinedService.delSearchConditions(user, uniqueId);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/gridItemSave"})
    ResponseEntity<?> saveGrid(@RequestBody UserGridDTO userGridDTO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        this.userDefinedService.saveGridItems(userGridDTO, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/gridItem/{activityId}/{pageCode}"})
    ResponseEntity<?> getGrid(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @PathVariable String activityId, @PathVariable String pageCode) {
        UserGridDTO userGridDTO = new UserGridDTO();
        userGridDTO.setUserId(user.getUserId());
        userGridDTO.setTenantId(user.getTenantId());
        userGridDTO.setCode(activityId);
        userGridDTO.setPageCode(pageCode);
        return ResponseEntityWrapper.wrapperOk((Object)this.userDefinedService.getGridItems(userGridDTO));
    }

    @GetMapping(value={"/delGridItems/{uniqueId}"})
    ResponseEntity<?> delGrid(@PathVariable Long uniqueId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        this.userDefinedService.delGridItems(uniqueId, user);
        return ResponseEntityWrapper.wrapperOk();
    }
}

