package com.digiwin.athena.base.presentation.server.web.cache;

import com.digiwin.athena.appcore.cache.CacheManager;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.atdm.constant.AtdmCacheConstants;
import com.digiwin.athena.base.application.constant.BaseGlobalConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value = "")
@RestController
public class CacheController {
    @Autowired
    CacheManager cacheManager;

    /**
     * 清除qudc缓存
     */
    @GetMapping(value = "/api/cache/reset")
    public ResponseEntity<?> audcCacheReset() {
        cacheManager.batchDelete(BaseGlobalConstant.AUDC_CACHE_KEY_PREFIX, "*");
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 清除atdm缓存
     */
    @GetMapping(value = "/api/atdm/v1/cache/reset")
    public ResponseEntity<?> atdmCacheReset(Long size) {
        cacheManager.batchExpire(AtdmCacheConstants.CACHE_KEY_PREFIX, "*", size);
        return ResponseEntityWrapper.wrapperOk();
    }

}
