/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.trial;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.trial.sceneCard.SceneCardReq;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialSceneCardMapper;
import com.digiwin.athena.base.infrastructure.meta.po.trial.SceneCardData;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/scene/web"})
public class SceneWebController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SceneWebController.class);
    private final TrialSceneCardMapper trialSceneCardMapper;

    @Autowired
    public SceneWebController(TrialSceneCardMapper trialSceneCardMapper) {
        this.trialSceneCardMapper = trialSceneCardMapper;
    }

    @PostMapping(value={"/bindCard"}, produces={"application/json;charset=UTF-8"})
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public ResponseEntity<?> query(@RequestBody SceneCardReq sceneCardReq) {
        String userId = sceneCardReq.getUserId();
        String userName = sceneCardReq.getUserName();
        String tenantId = sceneCardReq.getTenantId();
        Integer type = sceneCardReq.getType();
        String cardId = sceneCardReq.getCardId();
        Long stepId = sceneCardReq.getStepId();
        if (Objects.isNull(stepId) || Objects.isNull(type) || Objects.isNull(userId) || Objects.isNull(userName) || Objects.isNull(tenantId) || Objects.isNull(cardId)) {
            return ResponseEntityWrapper.wrapperOk((Object)-1);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)userId);
        queryWrapper.eq((Object)"user_name", (Object)userName);
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"type", (Object)type);
        queryWrapper.eq((Object)"step_id", (Object)stepId);
        this.trialSceneCardMapper.delete((Wrapper)queryWrapper);
        SceneCardData insertData = new SceneCardData();
        BeanUtils.copyProperties((Object)sceneCardReq, (Object)insertData);
        insertData.setCreateDate(LocalDateTime.now());
        insertData.setModifyDate(LocalDateTime.now());
        int result = this.trialSceneCardMapper.insert((Object)insertData);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/query"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> query(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestParam(value="sceneId", required=false) Long sceneId, @RequestParam(value="stepId", required=false) Long stepId) {
        if (Objects.isNull(sceneId) && Objects.isNull(stepId)) {
            return ResponseEntityWrapper.wrapperOk((Object)-1);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!Objects.isNull(sceneId)) {
            queryWrapper.eq((Object)"scene_id", (Object)sceneId);
        }
        if (!Objects.isNull(stepId)) {
            queryWrapper.eq((Object)"step_id", (Object)stepId);
        }
        queryWrapper.eq((Object)"user_id", (Object)user.getUserId());
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        List list = this.trialSceneCardMapper.selectList((Wrapper)queryWrapper);
        if (list != null && !list.isEmpty()) {
            return ResponseEntityWrapper.wrapperOk(list.get(0));
        }
        return ResponseEntityWrapper.wrapperOk((Object)Collections.EMPTY_LIST);
    }
}

