package com.digiwin.athena.base.presentation.server.web.cofw;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.service.cofw.CofwService;
import com.digiwin.athena.base.infrastructure.meta.po.cofw.Cofw;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/api/audc/v1/cofw")
public class CofwActionController {
    private static final Logger logger = LoggerFactory.getLogger(CofwActionController.class);

    /**
     * 快照逻辑删除标记：0有效，1删除
     */
    public static final int DEL_FLAG_0 = 0;
    /**
     * 快照逻辑删除标记：0有效，1删除
     */
    public static final int DEL_FLAG_1 = 1;

    @Autowired
    private CofwService cofwService;

    /**
     * xuxx 2021-08-27 add
     * 根据当前用户信息，获取快照列表
     *
     * @return
     */
    @GetMapping("/list")
    ResponseEntity<?> getCofwListActions(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        List<Cofw> list = cofwService.getCofwList(user);
        return ResponseEntityWrapper.wrapperOk(list);
    }

    /**
     * xuxx 2021-08-27 add
     * 保存任务详情和项目详情快照（改名为收藏）
     *
     * @return
     */
    @PostMapping("/save")
    ResponseEntity<?> saveCofwActions(@RequestBody JSONObject cofwbody,
                                      @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        cofwService.save(user, cofwbody);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * xuxx 2021-08-27 add
     * 根据快照ID获取某一个快照信息
     *
     * @return
     */
    @GetMapping("/getOneCofwById/{id}")
    ResponseEntity<?> getOneCofwByIdActions(@PathVariable long id,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        Cofw cofw = cofwService.getOneCofwById(id);
        return ResponseEntityWrapper.wrapperOk(cofw);
    }

    /**
     * xuxx 2021-08-27 add
     * 根据快照ID更新某一个快照信息
     *
     * @return
     */
    @PostMapping("/updateById")
    ResponseEntity<?> updateCofwByIdActions(@RequestBody JSONObject cofwreq,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        if (cofwreq != null) {
            long id = cofwreq.getLong("id");
            String cofwname = cofwreq.getString("cofwName");
            Cofw cofw = cofwService.getOneCofwById(id);
            if (cofw != null) {
                cofw.setCofwName(cofwname);
                cofw.setModifyTime(LocalDateTime.now());
                cofw.setModifyUserId(user.getUserId());
                cofwService.updateCofwById(cofw);
            }
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * xuxx 2021-08-27 add
     * 根据ID逻辑删除某一个快照
     *
     * @return
     */
    @GetMapping("/deleteById/{id}")
    ResponseEntity<?> deleteCofwByIdActions(@PathVariable long id,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        Cofw cofw = cofwService.getOneCofwById(id);
        if (cofw != null) {
            cofw.setDelFlag(DEL_FLAG_1);
            cofw.setDelUserId(user.getUserId());
            cofw.setDelTime(LocalDateTime.now());
            cofwService.updateCofwById(cofw);
        }
        return ResponseEntityWrapper.wrapperOk();
    }


    /**
     * 根据租户id清理快照数据
     *
     * @param tenantId 租户id
     * @param user     登录用户信息
     * @return result
     */
    @GetMapping("/deleteByTenant/{tenantId}")
    ResponseEntity<?> deleteByTenant(@PathVariable String tenantId,
                                     @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        logger.info("UserId:[" + user.getUserId() + "] Name:[" + user.getUserName() + "] Ready to Delete snapshot info");
        Map<String, Object> retMap = new HashMap<>();
        int result = cofwService.deleteByTenant(tenantId);
        if (result >= 0) {
            retMap.put("retCode", "0");
            retMap.put("retDesc", "delete success");
            retMap.put("effectNum", result);
        } else {
            retMap.put("retCode", "-1");
            retMap.put("retDesc", "delete fail");
            retMap.put("effectNum", 0);
        }
        logger.info("UserId:[" + user.getUserId() + "] Name:[" + user.getUserName()
                + "]  Delete snapshot info with retCode:[" + MapUtils.getString(retMap, "code") + "]");

        return ResponseEntityWrapper.wrapperOk(retMap);
    }
}
