package com.digiwin.athena.base.presentation.server.web.env;

import cn.hutool.core.lang.Tuple;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.base.infrastructure.config.EnvProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author yanyn
 */
@RestController
@RequestMapping("/api/env")
public class EnvController {
    @Autowired
    EnvProperties envProperties;

    @Autowired
    RemoteProperties remoteProperties;

    /**
     * 返回环境参数
     */
    @GetMapping(value = {""})
    public ResponseEntity<?> getRuntimeEnv() {
        envProperties.refresh();
        remoteProperties.refresh();

        Tuple env = new Tuple(envProperties, remoteProperties);
        return ResponseEntity.ok(env);
    }
}
