package com.digiwin.athena.base.presentation.server.web.proxyinfo;

import com.digiwin.app.log.JsonUtil;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoRemoveReq;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoSaveReq;
import com.digiwin.athena.base.application.meta.request.proxyinfo.SaveSubordinateReq;
import com.digiwin.athena.base.application.service.proxyinfo.ProxyInfoService;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EocEmpInfoDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 代理人信息 controller
 *
 * @author chenpeng
 * @date 2024年8月29日
 * @since
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/audc/v1/proxy/info")
public class ProxyInfoController {
    @Autowired
    private ProxyInfoService proxyInfoService;

    /**
     * 保存代理人信息
     *
     * @param user
     * @param proxyInfoSaveReq
     * @return
     */
    @PostMapping("/save")
    public ResponseEntity<?> saveProxyInfo(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user,
                                           @RequestBody ProxyInfoSaveReq proxyInfoSaveReq) {
        log.info("saveProxyInfo request param :{}", JsonUtil.toString(proxyInfoSaveReq));
        proxyInfoService.saveProxyInfo(proxyInfoSaveReq, user);
        return ResponseEntityWrapper.wrapperOk();
    }


    /**
     * 清除代理人信息
     *
     * @param user
     * @param proxyInfoRemoveReq
     * @return
     */
    @PostMapping("/remove")
    public ResponseEntity<?> removeProxyInfo(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user,
                                             @RequestBody ProxyInfoRemoveReq proxyInfoRemoveReq) {
        log.info("removeProxyInfo request param :{}", JsonUtil.toString(proxyInfoRemoveReq));
        proxyInfoService.removeProxyInfo(proxyInfoRemoveReq, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 查询下属代理人列表
     *
     * @param user
     * @return
     */
    @GetMapping("/subordinate/query")
    public ResponseEntity<?> querySubordinate(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user) {
        List<EocEmpInfoDTO> resultList = proxyInfoService.querySubordinate(user);
        return ResponseEntityWrapper.wrapperOk(resultList);
    }

    /**
     * 保存下属代理人信息
     *
     * @param user
     * @param saveSubordinateReq
     * @return
     */
    @PostMapping("/subordinate/save")
    public ResponseEntity<?> saveSubordinate(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user,
                                           @RequestBody SaveSubordinateReq saveSubordinateReq) {
        log.info("saveSubordinate request param :{}", JsonUtil.toString(saveSubordinateReq));
        proxyInfoService.saveSubordinate(saveSubordinateReq, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 删除下属代理人信息
     * @param user
     * @param proxyInfoRemoveReq
     * @return
     */
    @PostMapping("/subordinate/remove")
    public ResponseEntity<?> removeSubordinate(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user,
                                           @RequestBody ProxyInfoRemoveReq proxyInfoRemoveReq) {
        log.info("removeSubordinate request param :{}", JsonUtil.toString(proxyInfoRemoveReq));
        proxyInfoService.removeSubordinate(proxyInfoRemoveReq, user);
        return ResponseEntityWrapper.wrapperOk();
    }
}
