package com.digiwin.athena.base.presentation.server.web.trial;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.config.BaseAudcDataSourceConfig;
import com.digiwin.athena.base.application.meta.request.trial.sceneCard.SceneCardReq;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialSceneCardMapper;
import com.digiwin.athena.base.infrastructure.meta.po.trial.SceneCardData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/28 09:24:11
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/scene/web")
public class SceneWebController {

    private final TrialSceneCardMapper trialSceneCardMapper;

    @Autowired
    public SceneWebController(TrialSceneCardMapper trialSceneCardMapper)
    {
        this.trialSceneCardMapper = trialSceneCardMapper;
    }

    /**
     * 获取场景或者步骤对应的步骤id
     *
     * @return ResponseEntity
     */
    @PostMapping(value = "/bindCard", produces = "application/json;charset=UTF-8")
    @Transactional(transactionManager = BaseAudcDataSourceConfig.BASE_AUDC_DATASOURCE_TRANSACTION_MANAGER_BUSINESS)
    public ResponseEntity<?> query(@RequestBody SceneCardReq sceneCardReq) {

        String userId = sceneCardReq.getUserId();
        String userName = sceneCardReq.getUserName();
        String tenantId = sceneCardReq.getTenantId();
        Integer type = sceneCardReq.getType();
        String cardId = sceneCardReq.getCardId();
        Long stepId = sceneCardReq.getStepId();
        if(Objects.isNull(stepId) || Objects.isNull(type) || Objects.isNull(userId) || Objects.isNull(userName) || Objects.isNull(tenantId) || Objects.isNull(cardId))
        {
            //缺少参数
            return ResponseEntityWrapper.wrapperOk(-1);
        }

        //根据条件删除信息
        QueryWrapper<SceneCardData> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id",userId);
        queryWrapper.eq("user_name",userName);
        queryWrapper.eq("tenant_id",tenantId);
        queryWrapper.eq("type",type);
        queryWrapper.eq("step_id",stepId);
        trialSceneCardMapper.delete(queryWrapper);

        SceneCardData insertData = new SceneCardData();
        BeanUtils.copyProperties(sceneCardReq,insertData);
        insertData.setCreateDate(LocalDateTime.now());
        insertData.setModifyDate(LocalDateTime.now());
        int result = trialSceneCardMapper.insert(insertData);
        return ResponseEntityWrapper.wrapperOk(result);
    }


    /**
     * 获取场景或者步骤对应的步骤id
     *
     * @return ResponseEntity
     */
    @GetMapping(value = "/query", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> query(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                             @RequestParam(value = "sceneId", required = false) Long sceneId,
                                             @RequestParam(value = "stepId", required = false) Long stepId) {

        if(Objects.isNull(sceneId) && Objects.isNull(stepId))
        {
            //缺少参数
            return ResponseEntityWrapper.wrapperOk(-1);
        }
        QueryWrapper<SceneCardData> queryWrapper = new QueryWrapper<>();
        if(!Objects.isNull(sceneId))
        {
            queryWrapper.eq("scene_id",sceneId);
        }
        if(!Objects.isNull(stepId))
        {
            queryWrapper.eq("step_id",stepId);
        }
        queryWrapper.eq("user_id",user.getUserId());
        queryWrapper.eq("tenant_id",user.getTenantId());
        List<SceneCardData> list = trialSceneCardMapper.selectList(queryWrapper);
        if(list!=null && !list.isEmpty())
        {
             return ResponseEntityWrapper.wrapperOk(list.get(0));
        }
        return ResponseEntityWrapper.wrapperOk(Collections.EMPTY_LIST);
    }
}
