package com.digiwin.athena.base.presentation.server.web.userdefined;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.userdefined.UserPageModelBodyDTO;
import com.digiwin.athena.base.application.service.userdefined.UserPageModelBaseDataService;
import com.digiwin.athena.base.infrastructure.constant.Constants;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/api/audc/v1/pageModel")
public class UserPageModelActionController {

    @Autowired
    private UserPageModelBaseDataService userPageModelBaseDataService;


    /**
     * 查询页面编辑状态：进入页面时获取编辑权限，成功则页面可编辑，失败则页面只读
     *
     * @param userPageModelDTO
     * @param user
     */
    @PostMapping("/baseData/getEdit")
    ResponseEntity<?> getEdit(@RequestBody UserPageModelBodyDTO userPageModelDTO,
                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(userPageModelBaseDataService.getEdit(user, userPageModelDTO));
    }

    /**
     * 占用页面编辑：页面操作编辑时，尝试获取编辑权限
     *
     * @param userPageModelDTO
     * @param user
     */
    @PostMapping("/baseData/updateEdit")
    ResponseEntity<?> updateEdit(@RequestBody UserPageModelBodyDTO userPageModelDTO,
                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        if (StringUtils.isEmpty(userPageModelDTO.getOperationType()) || Constants.USER_OPERATION_MSG_CATEGORY_TAKE_UP.equals(userPageModelDTO.getOperationType())) {
            return ResponseEntityWrapper.wrapperOk(userPageModelBaseDataService.updateEdit(user, userPageModelDTO));
        } else {
            return ResponseEntityWrapper.wrapperOk(userPageModelBaseDataService.deleteEdit(user, userPageModelDTO));
        }
    }

    /**
     * 解除页面编辑状态
     *
     * @param userPageModelDTO
     * @param user
     */
    @Deprecated
    @PostMapping("/baseData/deleteEdit")
    ResponseEntity<?> deleteEdit(@RequestBody UserPageModelBodyDTO userPageModelDTO,
                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(userPageModelBaseDataService.deleteEdit(user, userPageModelDTO));
    }

    /**
     * 前端定时上报用户状态
     *
     * @param userPageModelDTO
     * @param user
     */
    @PostMapping("/baseData/reportStatus")
    ResponseEntity<?> reportStatus(@RequestBody UserPageModelBodyDTO userPageModelDTO,
                                   @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(userPageModelBaseDataService.reportStatus(user, userPageModelDTO));
    }


}
