/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.datasource;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.atdm.adsc.CommonAdscService;
import com.digiwin.athena.atdm.datasource.DataQueryServiceWrapper;
import com.digiwin.athena.atdm.datasource.datasource.process.AtmcBatchDataSourceService;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.DataAddTaskInfoDTO;
import com.digiwin.athena.atdm.datasource.dto.DataQueryDTO;
import com.digiwin.athena.atdm.datasource.dto.QueryDataByActionDTO;
import com.digiwin.athena.atdm.datasource.dto.QueryDataByActionIdDTO;
import com.digiwin.athena.atdm.datasource.dto.QueryDataByDataSourceDTO;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/atdm/v1/data/"})
public class DataQueryController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataQueryController.class);
    @Autowired
    private CommonAdscService adscService;
    @Resource
    private AtmcBatchDataSourceService atmcBatchDataSourceService;
    @Autowired
    private DataQueryServiceWrapper dataQueryServiceWrapper;

    @PostMapping(value={"query/by/backlog/withmetadata"})
    public ResponseEntity<?> queryWithMetaData(HttpServletRequest request, @RequestBody DataQueryDTO dataQueryDTO) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataQueryServiceWrapper.queryWithMetaData(request, dataQueryDTO));
    }

    @PostMapping(value={"query/by/backlog"})
    public ResponseEntity<?> queryByBacklog(HttpServletRequest request, @RequestBody DataQueryDTO dataQueryDTO) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataQueryServiceWrapper.queryByBacklog(request, dataQueryDTO));
    }

    @PostMapping(value={"query/page/by/dataset", "open/query/page/by/dataset"})
    public ResponseEntity<?> queryPageDataByDatasource(HttpServletRequest request, @RequestBody DataQueryDTO dataQueryDTO) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataQueryServiceWrapper.queryPageDataByDatasource(request, dataQueryDTO));
    }

    @PostMapping(value={"query/page/filterData"})
    @Deprecated
    public ResponseEntity<?> queryPageDataWithCondition(HttpServletRequest request, @RequestBody DataQueryDTO dataQueryDTO) {
        dataQueryDTO.getExecuteContext().setDataStateCode(dataQueryDTO.getDataStateCode());
        return this.queryPageDataByDatasource(request, dataQueryDTO);
    }

    @PostMapping(value={"query/filterCondition"})
    public ResponseEntity<?> queryFilterCondition(@RequestBody DataQueryDTO dataQueryDTO) {
        dataQueryDTO.getExecuteContext().setDataStateCode(dataQueryDTO.getDataStateCode());
        Map result = this.adscService.queryConditions(dataQueryDTO.getExecuteContext(), dataQueryDTO.getConditionFeildId(), dataQueryDTO.getSearchInfo());
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @PostMapping(value={"size/by/backlog"})
    public ResponseEntity<?> querySize(HttpServletRequest request, @RequestBody DataQueryDTO dataQueryDTO) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataQueryServiceWrapper.querySize(request, dataQueryDTO));
    }

    @PostMapping(value={"size/by/dataSource"})
    public ResponseEntity<?> querySizeByDataSize(HttpServletRequest request, @RequestBody DataQueryDTO dataQueryDTO) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataQueryServiceWrapper.querySizeByDataSize(request, dataQueryDTO));
    }

    @PostMapping(value={"query/by/datasource"})
    public ResponseEntity<?> queryByDatasource(HttpServletRequest request, @RequestBody QueryDataByDataSourceDTO queryDataByActionVO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataQueryServiceWrapper.queryByDatasource(request, queryDataByActionVO, user));
    }

    @PostMapping(value={"query/by/action", "open/query/by/action"})
    public ResponseEntity<?> actionData(HttpServletRequest request, @RequestBody QueryDataByActionDTO queryDataByActionDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataQueryServiceWrapper.actionData(request, queryDataByActionDTO, user));
    }

    @PostMapping(value={"query/by/actionId", "open/query/by/actionId"})
    public ResponseEntity<?> queryByActionId(HttpServletRequest request, @RequestBody QueryDataByActionIdDTO queryDataByActionDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataQueryServiceWrapper.queryByActionId(request, queryDataByActionDTO, user));
    }

    @PostMapping(value={"size/by/dataSource/abnormal"})
    public ResponseEntity<?> querySizeByDataSizeAbnormal(HttpServletRequest request, @RequestBody DataQueryDTO dataQueryDTO) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataQueryServiceWrapper.querySizeByDataSizeAbnormal(request, dataQueryDTO));
    }

    @PostMapping(value={"process/batch"})
    @Deprecated
    public ResponseEntity<?> atmcBathDataSourceServreOld(HttpServletRequest request, @RequestBody DataAddTaskInfoDTO dataAddTaskInfoDTO) {
        return this.atmcBathDataSourceServ(request, dataAddTaskInfoDTO);
    }

    @PostMapping(value={"process/batch/addTaskInfo"})
    public ResponseEntity<?> atmcBathDataSourceServ(HttpServletRequest request, @RequestBody DataAddTaskInfoDTO dataAddTaskInfoDTO) {
        if (Objects.isNull(dataAddTaskInfoDTO.getDataSourceProcessor())) {
            throw new IllegalArgumentException("dataSourceProcessor cannot be null");
        }
        if (!"atmcBatchDataService".equals(dataAddTaskInfoDTO.getDataSourceProcessor().getServiceName())) {
            throw new IllegalArgumentException("dataSourceProcessor must be a name of atmcBatchDataService");
        }
        if (CollectionUtils.isEmpty((Collection)dataAddTaskInfoDTO.getData())) {
            return ResponseEntityWrapper.wrapperOk((Object)ListUtils.EMPTY_LIST);
        }
        long start = System.currentTimeMillis();
        QueryResult queryResult = new QueryResult();
        queryResult.setData(dataAddTaskInfoDTO.getData());
        this.atmcBatchDataSourceService.handelData(null, dataAddTaskInfoDTO.getExecuteContext(), dataAddTaskInfoDTO.getDataSourceProcessor(), queryResult);
        log.info("[{}]\u5e94\u7528\u8c03\u7528\u6279\u91cf\u589e\u52a0\u5f85\u529e\u4fe1\u606f\u63a5\u53e3,\u6570\u636e\u91cf[{}]\u6761,\u8017\u65f6[{}]ms", new Object[]{dataAddTaskInfoDTO.getClientCode(), dataAddTaskInfoDTO.getData().size(), System.currentTimeMillis() - start});
        return ResponseEntityWrapper.wrapperOk((Object)queryResult.getData());
    }
}

