package com.digiwin.athena.base.presentation.server.web.usermeta;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.usermeta.MetadataConstant;
import com.digiwin.athena.base.application.meta.request.usermeta.UserMetadataItemReqDTO;
import com.digiwin.athena.base.application.service.usermeta.UserMetadataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * UserMetadataController Description
 *
 * @author majianfu
 * @date 2024/8/22
 * @since
 */
@RestController
@RequestMapping(value = "/api/v1/user/metadata")
public class UserMetadataController {
    @Autowired
    private UserMetadataService userMetadataService;

    /**
     * 查询批量用户的消息发送方式设定。
     * 若入参userIds/tenantSid为空，则默认查询当前用户userId/tenantSid的消息发送方式设定
     * <p>
     * 若从IAM未能查询到该用户的元数据（用户不存在或初始化后未在Athena手动修改过元数据）或元数据中不包含消息发送方式，
     * 则默认返回该用户的消息发送方式为{@link MetadataConstant#MESSAGE_SEND_TYPE_IM}
     *
     * @param messageSendTypeReq
     * @param authoredUser
     * @return
     */
    @PostMapping("/messageSendType/batch")
    public ResponseEntity<?> batchQueryUserMessageSendType(@Valid @RequestBody UserMetadataItemReqDTO messageSendTypeReq,//NOSONAR
                                                           @RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser authoredUser) {
        return ResponseEntityWrapper.wrapperOk(userMetadataService.queryBatchUserMessageSendType(messageSendTypeReq, authoredUser));
    }

}
