/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.action;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.atdm.action.executor.DataSubmissionServiceWrapper;
import com.digiwin.athena.atdm.activity.domain.MergeSubmitActionDTO;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/atdm/v1/action/"})
public class ActionExecuteController {
    private static final Logger log = LoggerFactory.getLogger(ActionExecuteController.class);
    @Autowired
    private DataSubmissionServiceWrapper dataSubmissionServiceWrapper;

    @PostMapping(value={"/submit/task", "/open/submit/task"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> executeAction(HttpServletRequest request, @RequestBody SubmitActionDTO submitAction) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataSubmissionServiceWrapper.executeAction(request, submitAction));
    }

    @PostMapping(value={"/execute", "/open/execute"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> executeOpenTaskWindowAction(HttpServletRequest request, @RequestBody SubmitActionDTO submitAction) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataSubmissionServiceWrapper.executeOpenTaskWindowAction(request, submitAction));
    }

    @PostMapping(value={"/submit/returnTask"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> executeReturnAction(HttpServletRequest request, @RequestBody List<SubmitActionDTO> submitActionList) throws Throwable {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataSubmissionServiceWrapper.executeReturnAction(request, submitActionList));
    }

    @PostMapping(value={"/submit/mergeTask"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> executeMergeAction(HttpServletRequest request, @RequestBody List<SubmitActionDTO> submitActionList) throws Throwable {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataSubmissionServiceWrapper.executeMergeAction(request, submitActionList));
    }

    @PostMapping(value={"/submit/mergeTaskCrossBk"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> executeMergeActionCrossBk(HttpServletRequest request, @RequestBody List<SubmitActionDTO> submitActionList) throws Throwable {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataSubmissionServiceWrapper.executeMergeActionCrossBk(request, submitActionList));
    }

    @PostMapping(value={"/submit/mergeTaskRetry"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> executeMergeActionRetry(HttpServletRequest request, @RequestBody MergeSubmitActionDTO mergeSubmitAction) throws Throwable {
        return ResponseEntityWrapper.wrapperOk((Object)this.dataSubmissionServiceWrapper.executeMergeActionRetry(request, mergeSubmitAction));
    }
}

