/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.recycle;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.atdm.recycle.CommonRecycleService;
import com.digiwin.athena.atdm.recycle.dto.RecycleRecordStateChangeDTO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/atdm/v1/recycle/"})
public class RecycleController {
    @Autowired
    private CommonRecycleService commonRecycleService;

    @PostMapping(value={"count/by/tenantId"})
    public ResponseEntity<?> queryRecycleCount() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        int recycleCount = this.commonRecycleService.getRecycleCount(tenantId);
        return ResponseEntityWrapper.wrapperOk((Object)recycleCount);
    }

    @PostMapping(value={"query/list"})
    public ResponseEntity<?> queryRecycleList() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List recycleList = this.commonRecycleService.queryActivityList(tenantId);
        return ResponseEntityWrapper.wrapperOk((Object)recycleList);
    }

    @DeleteMapping(value={"deleteAll"})
    public ResponseEntity<?> deleteAll() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        this.commonRecycleService.deleteAll(tenantId);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"state/expired"})
    public ResponseEntity<?> markExpired(@RequestBody @Validated RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        this.commonRecycleService.markExpired(recycleRecordStateChangeDTO);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"state/unexpired"})
    public ResponseEntity<?> markUnexpired(@RequestBody @Validated RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        this.commonRecycleService.markUnexpired(recycleRecordStateChangeDTO);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/state/deleted"})
    public ResponseEntity<?> markDeleted(@RequestBody @Validated RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        this.commonRecycleService.markDeleted(recycleRecordStateChangeDTO);
        return ResponseEntityWrapper.wrapperOk();
    }
}

