/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.usertrack;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.IndexOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user/track/repair"})
public class RepairUserTrackController {
    @Resource
    private MongoTemplate trackMongoTemplate;

    @GetMapping(value={"/query/queryCollections"})
    public ResponseEntity queryAllCollectionInfo() {
        Set collectionInfo = this.trackMongoTemplate.getCollectionNames();
        return ResponseEntityWrapper.wrapperOk((Object)collectionInfo);
    }

    @GetMapping(value={"/query/getIndexInfo"})
    public ResponseEntity queryIndexInfo(@RequestParam(value="collection", required=false) String collectionName) {
        ListIndexesIterable currentIndexes = this.trackMongoTemplate.getCollection(collectionName).listIndexes();
        MongoCursor cursor = currentIndexes.iterator();
        HashSet<Object> indexNames = new HashSet<Object>();
        while (cursor.hasNext()) {
            Object next = cursor.next();
            indexNames.add(next);
        }
        return ResponseEntityWrapper.wrapperOk(indexNames);
    }

    @PostMapping(value={"/handle/batchSetIndex"})
    public ResponseEntity batchSetIndex(@RequestParam(value="collections", required=false) String collectionNames, @RequestBody Document document) {
        String[] collArrs = collectionNames.split(",");
        HashedMap result = new HashedMap();
        for (String col : collArrs) {
            IndexOptions indexOptions = new IndexOptions();
            indexOptions.background(true);
            String tempResult = this.trackMongoTemplate.getCollection(col).createIndex((Bson)document, indexOptions);
            result.put(col, tempResult);
        }
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/handle/dropIndex"})
    public ResponseEntity dropIndex(@RequestParam(value="collection", required=false) String collectionName, @RequestParam(value="indexName", required=false) String indexName) {
        try {
            this.trackMongoTemplate.getCollection(collectionName).dropIndex(indexName);
        }
        catch (Exception e) {
            return ResponseEntityWrapper.wrapperOk((Object)"\u5220\u9664\u7d22\u5f15\u5f02\u5e38");
        }
        return ResponseEntityWrapper.wrapperOk((Object)"\u5220\u9664\u7d22\u5f15\u6210\u529f");
    }

    @PostMapping(value={"/handle/batchQuerySetIndex"})
    public ResponseEntity batchQuerySetIndex(@RequestBody Document document) {
        Set totalColls = this.trackMongoTemplate.getCollectionNames();
        HashSet<String> failColls = new HashSet<String>();
        for (String col : totalColls) {
            try {
                IndexOptions indexOptions = new IndexOptions();
                indexOptions.background(true);
                String string = this.trackMongoTemplate.getCollection(col).createIndex((Bson)document, indexOptions);
            }
            catch (Exception e) {
                failColls.add(col);
            }
        }
        HashMap<String, Set> result = new HashMap<String, Set>();
        result.put("totalColls", totalColls);
        result.put("failColls", failColls);
        return ResponseEntityWrapper.wrapperOk(result);
    }

    @PostMapping(value={"/query/count"})
    public ResponseEntity countData(@RequestParam(value="collection", required=false) String collectionName, @RequestBody Document document) {
        if (null == document) {
            return ResponseEntityWrapper.wrapperOk((Object)this.trackMongoTemplate.getCollection(collectionName).countDocuments());
        }
        return ResponseEntityWrapper.wrapperOk((Object)this.trackMongoTemplate.getCollection(collectionName).countDocuments((Bson)document));
    }

    @PostMapping(value={"/query/explain"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> queryExplain(@RequestBody Document document) {
        Document explainDoc = new Document();
        explainDoc.put("explain", (Object)document);
        return ResponseEntityWrapper.wrapperOk((Object)this.trackMongoTemplate.executeCommand(explainDoc));
    }
}

