/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.usertrack;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.usertrack.AccountDTO;
import com.digiwin.athena.base.application.meta.request.usertrack.UserTrackSearchDTO;
import com.digiwin.athena.base.application.service.usertrack.UserTrackService;
import com.digiwin.athena.base.infrastructure.meta.po.usertrack.mongo.UserTrackExtendDTO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/user/track"})
public class UserTrackController {
    @Autowired
    private UserTrackService userTrackService;

    @PostMapping(value={"/report"})
    public ResponseEntity<?> reportUserTrack(@RequestBody List<UserTrackExtendDTO> userTrackList) {
        this.userTrackService.handleReportData(userTrackList);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/clear"})
    public ResponseEntity<?> clearReportData(@RequestBody AccountDTO account) {
        this.userTrackService.clearReportData(account);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<?> findByParam(@RequestBody UserTrackSearchDTO userTrackSearchDTO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.userTrackService.findByParam(userTrackSearchDTO, user));
    }
}

