/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.visit;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.request.visit.VisitInfoReq;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.mapper.audc.visit.VisitInfoMapper;
import com.digiwin.athena.base.infrastructure.meta.po.visit.VisitInfoData;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/visit"})
public class VisitController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VisitController.class);
    private VisitInfoMapper visitInfoMapper;

    @Autowired
    public VisitController(VisitInfoMapper visitInfoMapper) {
        this.visitInfoMapper = visitInfoMapper;
    }

    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    @PostMapping(value={"/submit"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> submitInfo(@RequestBody VisitInfoReq req, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (StringUtils.isEmpty((String)req.getModuleNo())) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException("Module No must not be empty.");
        }
        VisitInfoData data = new VisitInfoData();
        BeanUtils.copyProperties((Object)req, (Object)data);
        data.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        data.setCreateDate(LocalDateTime.now());
        data.setModifyDate(LocalDateTime.now());
        data.setUserId(user.getUserId());
        data.setUserName(user.getUserName());
        data.setTenantId(user.getTenantId());
        int result = this.visitInfoMapper.insertOrUpdateVisitInfo(data);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/query"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> query(@RequestParam(name="moduleNo") String moduleNo, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        boolean isSpecialModuleNo;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"module_no", (Object)moduleNo);
        query.eq((Object)"user_id", (Object)user.getUserId());
        query.eq((Object)"tenant_id", (Object)user.getTenantId());
        VisitInfoData result = (VisitInfoData)this.visitInfoMapper.selectOne((Wrapper)query);
        boolean bl = isSpecialModuleNo = "task-sort-config".equals(moduleNo) || "project-sort-config".equals(moduleNo) || "team-task-sort-config".equals(moduleNo) || "team-project-sort-config".equals(moduleNo);
        if (isSpecialModuleNo) {
            this.convertHistoryDetailSpecialModuleNo(result);
        }
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    private void convertHistoryDetailSpecialModuleNo(VisitInfoData result) {
        try {
            if (null != result && StringUtils.isNotEmpty((String)result.getDetail())) {
                HashMap detailMap = Maps.newHashMap();
                if (JSONUtil.isJsonObj((String)result.getDetail())) {
                    JSONObject jsonObject = JSONUtil.parseObj((String)result.getDetail());
                    JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"all");
                    ArrayList list = Lists.newArrayList();
                    if (null != jsonArray && jsonArray.size() > 0) {
                        JSONObject detail = (JSONObject)jsonArray.get(0);
                        if (detail.containsKey((Object)"selectedOption")) {
                            return;
                        }
                        for (Object obj : jsonArray) {
                            String sortType;
                            HashMap map = Maps.newHashMap();
                            JSONObject j = (JSONObject)obj;
                            String paramName = j.getStr((Object)"paramName");
                            if ("READ_STATUS".equals(paramName)) {
                                sortType = j.getStr((Object)"sortType");
                                if ("desc".equals(sortType)) {
                                    map.put("type", "readStatus");
                                    map.put("selectedOption", "readStatusUnread");
                                    map.put("defaultOption", "readStatusUnread");
                                    map.put("swith", true);
                                } else if ("asc".equals(sortType)) {
                                    map.put("type", "readStatus");
                                    map.put("selectedOption", "readStatusRead");
                                    map.put("defaultOption", "readStatusRead");
                                    map.put("swith", true);
                                }
                            } else if ("FINISH_TIME".equals(paramName)) {
                                sortType = j.getStr((Object)"sortType");
                                if ("desc".equals(sortType)) {
                                    map.put("type", "time");
                                    map.put("selectedOption", "timeEndTimeDesc");
                                    map.put("defaultOption", "timeEndTimeDesc");
                                    map.put("swith", true);
                                } else if ("asc".equals(sortType)) {
                                    map.put("type", "time");
                                    map.put("selectedOption", "timeEndTimeAsc");
                                    map.put("defaultOption", "timeEndTimeAsc");
                                    map.put("swith", true);
                                }
                            } else if ("TIME".equals(paramName)) {
                                Object o;
                                JSONArray cascaderModel;
                                sortType = j.getStr((Object)"sortType");
                                if ("asc".equals(sortType)) {
                                    cascaderModel = j.getJSONArray((Object)"cascaderModel");
                                    if (cascaderModel.size() > 1 && (o = cascaderModel.get(1)) != null && o.toString().equals("endTime")) {
                                        map.put("type", "time");
                                        map.put("selectedOption", "projectTimeEndTimeAsc");
                                        map.put("defaultOption", "projectTimeEndTimeAsc");
                                        map.put("swith", true);
                                    }
                                } else if ("desc".equals(sortType) && (cascaderModel = j.getJSONArray((Object)"cascaderModel")).size() > 1 && (o = cascaderModel.get(1)) != null && o.toString().equals("endTime")) {
                                    map.put("type", "time");
                                    map.put("selectedOption", "projectTimeEndTimeDesc");
                                    map.put("defaultOption", "projectTimeEndTimeDesc");
                                    map.put("swith", true);
                                }
                            } else if ("NAME".equals(paramName)) {
                                sortType = j.getStr((Object)"sortType");
                                if ("desc".equals(sortType)) {
                                    map.put("type", "name");
                                    map.put("selectedOption", "projectNameDesc");
                                    map.put("defaultOption", "projectNameDesc");
                                    map.put("swith", true);
                                } else if ("asc".equals(sortType)) {
                                    map.put("type", "name");
                                    map.put("selectedOption", "projectNameAsc");
                                    map.put("defaultOption", "projectNameAsc");
                                    map.put("swith", true);
                                }
                            } else if ("OVERDUE_EXCEPTION".equals(paramName)) {
                                sortType = j.getStr((Object)"sortType");
                                if ("desc".equals(sortType)) {
                                    map.put("type", "overdueException");
                                    map.put("selectedOption", "overdueExceptionOff");
                                    map.put("defaultOption", "overdueExceptionOff");
                                    map.put("swith", true);
                                } else if ("asc".equals(sortType)) {
                                    map.put("type", "overdueException");
                                    map.put("selectedOption", "overdueExceptionOn");
                                    map.put("defaultOption", "overdueExceptionOn");
                                    map.put("swith", true);
                                }
                            } else if ("TASK_TYPE".equals(paramName)) {
                                map.put("type", "taskType");
                                map.put("selectedOption", "taskTypeFront");
                                map.put("swith", true);
                            } else {
                                map.put("type", "label");
                                map.put("selectedOption", "setLabelFront");
                                map.put("switch", true);
                            }
                            list.add(map);
                        }
                        detailMap.put("all", list);
                        result.setDetail(JSONUtil.toJsonStr((Object)detailMap));
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("convert history error", (Throwable)ex);
        }
    }

    @GetMapping(value={"/query/order"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> queryOrder(@RequestParam(name="moduleNo") String moduleNo, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"module_no", (Object)moduleNo);
        query.eq((Object)"user_id", (Object)user.getUserId());
        query.eq((Object)"tenant_id", (Object)user.getTenantId());
        VisitInfoData result = (VisitInfoData)this.visitInfoMapper.selectOne((Wrapper)query);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }
}

