package com.digiwin.athena.base.presentation.server.web.userdefined;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.dto.userdefined.FusionComponentUserDefinedDTO;
import com.digiwin.athena.base.application.service.userdefined.UserDefinedService;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserDefinedCenterDTO;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserGridDTO;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/api/audc/v1/userdefined")
public class UserDefinedActionController {


    @Autowired
    JsonConfig jsonConfig;
    @Autowired
    private UserDefinedService userDefinedService;

    /**
     * xuxx 2022-01-05 add
     * 根据当前用户信息，获取保存的顺序tag
     *
     * @param pageUniqueCode 视图编码
     * @return
     */
    @GetMapping(value = {"/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}","/open/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}"})
    ResponseEntity<?> getFieldSeqListActions(@PathVariable("pageCode") String pageCode,
                                             @PathVariable("tmProjectId") String tmProjectId,
                                             @PathVariable("tmActivityId") String tmActivityId,
                                             @RequestParam(required = false) String pageUniqueCode,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        UserDefinedCenterDTO userDefined = userDefinedService.getFieldSeqList(user,pageCode,tmProjectId ,tmActivityId,null, pageUniqueCode);
        if(CollectionUtils.isNotEmpty(userDefined.getMetadataTags())){
            return ResponseEntityWrapper.wrapperOk(userDefined.getMetadataTags());
        }
        return ResponseEntityWrapper.wrapperOk(new ArrayList<>());
    }

    /**
     * 根据任务id批量获取自定义字段；uibot使用；
     *
     * @param tmActivityIdList
     * @return
     */
    @PostMapping("/batch/fieldlist")
    ResponseEntity<?> getFieldSeqListActions(@RequestBody List<String> tmActivityIdList){
        return ResponseEntityWrapper.wrapperOk(userDefinedService.getFieldSeqList(tmActivityIdList));
    }

    /**
     * xusj 2022-12-22 add
     * 根据当前用户信息和schema，获取保存的顺序tag
     * @return
     */
    @GetMapping(value = {"/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}/{tableSchema}", "/open/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}/{tableSchema}"})
    ResponseEntity<?> getFieldSeqListActionsV2(@PathVariable("pageCode") String pageCode,
                                             @PathVariable("tmProjectId") String tmProjectId,
                                             @PathVariable("tmActivityId") String tmActivityId,
                                             @PathVariable("tableSchema") String tableSchema,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        UserDefinedCenterDTO  userDefined = userDefinedService.getFieldSeqList(user,pageCode,tmProjectId ,tmActivityId,tableSchema);
        if(CollectionUtils.isNotEmpty(userDefined.getMetadataTags())){
            return ResponseEntityWrapper.wrapperOk(userDefined.getMetadataTags());
        }
        return ResponseEntityWrapper.wrapperOk(new ArrayList<>());
    }

    /**
     * xuxx 2022-01-05 add
     * 根据当前用户信息，保存栏位顺序
     *
     * @return
     */
    @PostMapping(value = {"/save","/open/save"})
    ResponseEntity<?> saveFieldSeqActions(@RequestBody Map fieldJson,
                                     @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){

        JSONObject jsonObject =  JsonUtils.jsonToObject(JsonUtils.objectToString(fieldJson),JSONObject.class);
        userDefinedService.save(user, jsonObject);
        return ResponseEntityWrapper.wrapperOk();
    }


    /**
     * xuxx 2022-01-05 add
     * 根据当前用户信息，删除用户定义的栏位顺序
     * 某一个
     * @return
     */
    @GetMapping(value = {"/remove/{pageCode}/{tmProjectId}/{tmActivityId}/{tableSchema.*}", "/open/remove/{pageCode}/{tmProjectId}/{tmActivityId}/{tableSchema.*}"})
    ResponseEntity<?> removeFieldSeqActions(@PathVariable("pageCode") String pageCode,
                                            @PathVariable("tmProjectId") String tmProjectId,
                                            @PathVariable("tmActivityId") String tmActivityId,
                                            @PathVariable("tableSchema.*") String tableSchema,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        userDefinedService.remove(user,pageCode,tmProjectId ,tmActivityId,tableSchema);
        return ResponseEntityWrapper.wrapperOk();
    }
    /**
     * xuxx 2022-01-05 add
     * 根据当前用户信息，删除用户定义的栏位顺序
     * 全部
     *
     * @return
     */
    @GetMapping(value = {"/remove/{pageCode}/{tmProjectId}/{tmActivityId}", "/open/remove/{pageCode}/{tmProjectId}/{tmActivityId}"})
    ResponseEntity<?> removeFieldSeqActions(@PathVariable("pageCode") String pageCode,
                                            @PathVariable("tmProjectId") String tmProjectId,
                                            @PathVariable("tmActivityId") String tmActivityId,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        userDefinedService.remove(user,pageCode,tmProjectId ,tmActivityId,null);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * xuxx 2022-03-08 add
     * 根据当前用户信息，保存数据排序条件
     *
     * @return
     */
    @PostMapping("/orderconditions/save")
    ResponseEntity<?> saveOrderConditionsActions(@RequestBody Map fieldJson,
                                          @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        JSONObject jsonObject =  JsonUtils.jsonToObject(JsonUtils.objectToString(fieldJson),JSONObject.class);
        userDefinedService.saveOrderConditions(user, jsonObject);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * xuxx 2022-03-08 add
     * 根据当前用户信息，获取数据排序条件
     *
     * @param pageUniqueCode 视图编码
     * @return
     */
    @GetMapping("/orderconditions/fields/{pageCode}/{tmProjectId}/{tmActivityId}")
    ResponseEntity<?> getOrderConditionsActions(@PathVariable("pageCode") String pageCode,
                                             @PathVariable("tmProjectId") String tmProjectId,
                                             @PathVariable("tmActivityId") String tmActivityId,
                                             @RequestParam(required = false) String pageUniqueCode,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        UserDefinedCenterDTO  userDefined = userDefinedService.getOrderConditionsByUser(user,pageCode,tmProjectId ,tmActivityId,null, pageUniqueCode);
        if(userDefined.getSettings() != null){
            return ResponseEntityWrapper.wrapperOk(userDefined.getSettings());
        }
        return ResponseEntityWrapper.wrapperOk(new JSONObject());
    }

    /**
     * 根据当前用户信息，获取数据排序条件
     * @return
     */
    @GetMapping("/orderconditions/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}")
    ResponseEntity<?> getOrderConditionsFileds(@PathVariable("pageCode") String pageCode,
                                                @PathVariable("tmProjectId") String tmProjectId,
                                                @PathVariable("tmActivityId") String tmActivityId,
                                                @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        List<UserDefinedCenterDTO> userDefined = userDefinedService.getOrderConditionsFields(user,pageCode,tmProjectId ,tmActivityId,null);
        userDefined = userDefined.stream().filter(x -> x.getSettings() != null).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(userDefined)){
            return ResponseEntityWrapper.wrapperOk(userDefined.stream().map(defined -> defined.getSettings()).collect(Collectors.toList()));
        }
        return ResponseEntityWrapper.wrapperOk(Lists.newArrayList());
    }

    /**
     * xuxx 2022-03-08 add
     * 根据当前用户信息，删除用户定义的数据排序条件
     * 全部
     * @return
     */
    @GetMapping("/orderconditions/remove/{pageCode}/{tmProjectId}/{tmActivityId}")
    ResponseEntity<?> removeOrderConditionsActions(@PathVariable("pageCode") String pageCode,
                                            @PathVariable("tmProjectId") String tmProjectId,
                                            @PathVariable("tmActivityId") String tmActivityId,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        userDefinedService.removeOrderConditions(user,pageCode,tmProjectId ,tmActivityId,null);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * xuxx 2022-03-08 add
     * 根据当前用户信息，删除用户定义的数据排序条件
     * 某一个
     * @return
     */
    @GetMapping("/orderconditions/remove/{pageCode}/{tmProjectId}/{tmActivityId}/{tableSchema.*}")
    ResponseEntity<?> removeOrderConditionsActions(@PathVariable("pageCode") String pageCode,
                                                   @PathVariable("tmProjectId") String tmProjectId,
                                                   @PathVariable("tmActivityId") String tmActivityId,
                                                   @PathVariable("tableSchema.*") String tableSchema,
                                                   @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        userDefinedService.removeOrderConditions(user,pageCode,tmProjectId ,tmActivityId,tableSchema);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 查询基础资料录入的展开收起状态
     * @Author: tangJieCheng-17257
    **/
    @GetMapping("/userShrink/{tmActivityId}")
    ResponseEntity<?> getUserShrink( @PathVariable("tmActivityId") String tmActivityId,
            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        UserDefinedCenterDTO userDefined = userDefinedService.getUserShrink(user,tmActivityId);
        if(userDefined.getSettings() != null){
            return ResponseEntityWrapper.wrapperOk(userDefined.getSettings());
        }
        return ResponseEntityWrapper.wrapperOk(new JSONObject());
    }

    /**
     * 保存基础资料录入的展开收起状态
     *
     * @Author: tangJieCheng-17257
     **/
    @PostMapping("/userShrink/save")
    ResponseEntity<?> saveUserShrink(@RequestBody JSONObject fieldJson, @RequestAttribute(value =
            GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        userDefinedService.saveUserShrink(user, fieldJson);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * xuxx 2022-06-20 add
     * 表格独立使用，根据当前用户信息，获取字段及其属性
     * pageCode:project-detail、task-detail
     * tmProjectId:当前任务所对应的项目定义code
     * tmActivityId:当前任务所对应的任务定义code
     * table:当前表格对应的schema
     * @return
     */
    @GetMapping("/fieldArrtlist/{pageCode}/{tmProjectId}/{tmActivityId}/{table}")
    ResponseEntity<?> getFieldArrtListActions(@PathVariable("pageCode") String pageCode,
                                             @PathVariable("tmProjectId") String tmProjectId,
                                             @PathVariable("tmActivityId") String tmActivityId,
                                              @PathVariable("table") String table,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        Object  userDefined = userDefinedService.getFieldArrtList(user,pageCode,tmProjectId ,tmActivityId,table);
        return ResponseEntityWrapper.wrapperOk(userDefined);
    }

    /**
     * xuxx 2022-06-20 add
     * 表格独立使用，根据当前用户信息，获取字段及其属性
     * pageCode:project-detail、task-detail
     * tmProjectId:当前任务所对应的项目定义code
     * tmActivityId:当前任务所对应的任务定义code
     * table:当前表格对应的schema
     * @return
     */
    @GetMapping("/fieldArrtlist/{pageCode}/{tmProjectId}/{tmActivityId}")
    ResponseEntity<?> getFieldArrtListActions(@PathVariable("pageCode") String pageCode,
                                              @PathVariable("tmProjectId") String tmProjectId,
                                              @PathVariable("tmActivityId") String tmActivityId,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        Object  userDefined = userDefinedService.getFieldArrtList(user,pageCode,tmProjectId ,tmActivityId,null);
        return ResponseEntityWrapper.wrapperOk(userDefined);
    }

    /**
     * 查询表格高级查询常用条件配置
     * @param tmActivityId 作业code
     * @param pageCode 页面编码
     * @param tableSchema 表格schema
     * @param pageUniqueCode 视图编码
     * @param user 当前登录用户
     * @return
     */
    @GetMapping("/searchConditions/{tmActivityId}/{pageCode}/{tableSchema}")
    ResponseEntity<?> getSearchConditions(@PathVariable String tmActivityId,
                                          @PathVariable String pageCode,
                                          @PathVariable String tableSchema,
                                          @RequestParam(required = false) String pageUniqueCode,
                                          @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        UserDefinedCenterDTO userDefined = new UserDefinedCenterDTO();
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPageCode(pageCode);
        userDefined.setTableSchema(tableSchema);
        userDefined.setPageUniqueCode(pageUniqueCode);
        return ResponseEntityWrapper.wrapperOk(userDefinedService.getSearchConditions(user, userDefined));
    }

    /**
     * 存入表格高级查询常用条件配置
     * @param userDefined
     * @param user
     * @return
     */
    @PostMapping("/searchConditions/save")
    ResponseEntity<?> saveSearchConditions(@RequestBody UserDefinedCenterDTO userDefined, @RequestAttribute(value =
            GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(userDefinedService.saveSearchConditions(user, userDefined));
    }

    /**
     * 删除表格高级查询常用条件配置
     * @param uniqueId
     * @param user
     * @return
     */
    @PostMapping("/searchConditions/del/{uniqueId}")
    ResponseEntity<?> delSearchConditions(@PathVariable Long uniqueId, @RequestAttribute(value =
            GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        userDefinedService.delSearchConditions(user, uniqueId);
        return ResponseEntityWrapper.wrapperOk();
    }


    /**
     *
     * @param userGridDTO
     * @param user
     * @return
     */
    @PostMapping("/gridItemSave")
    ResponseEntity<?> saveGrid(@RequestBody UserGridDTO userGridDTO, @RequestAttribute(value =
            GlobalConstant.AUTH_USER) AuthoredUser user) {
        userDefinedService.saveGridItems(userGridDTO,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     *
     * @param user
     * @return
     */
    @GetMapping("/gridItem/{activityId}/{pageCode}")
    ResponseEntity<?> getGrid(@RequestAttribute(value =
            GlobalConstant.AUTH_USER) AuthoredUser user, @PathVariable String activityId,@PathVariable String pageCode){
        UserGridDTO userGridDTO = new UserGridDTO();
        userGridDTO.setUserId(user.getUserId());
        userGridDTO.setTenantId(user.getTenantId());
        userGridDTO.setCode(activityId);
        userGridDTO.setPageCode(pageCode);
        return ResponseEntityWrapper.wrapperOk(userDefinedService.getGridItems(userGridDTO));
    }

    @GetMapping("/delGridItems/{uniqueId}")
    ResponseEntity<?> delGrid(@PathVariable Long uniqueId,@RequestAttribute(value =
            GlobalConstant.AUTH_USER) AuthoredUser user) {
        userDefinedService.delGridItems(uniqueId,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value = {"/saveFusionComponent", "/open/saveFusionComponent"})
    ResponseEntity<?> saveFusionComponent(@RequestBody FusionComponentUserDefinedDTO dto,
                                          @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        dto.checkParam();
        if (Objects.isNull(dto.getContext())) {
            throw new RuntimeException("context is null");
        }
        dto.setTenantId(user.getTenantId());
        dto.setUserId(user.getUserId());
        userDefinedService.saveFusionComponent(dto);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value = {"/queryFusionComponent", "/open/queryFusionComponent"})
    ResponseEntity<?> queryFusionComponent(@RequestBody FusionComponentUserDefinedDTO dto,
                                          @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        dto.checkParam();
        dto.setTenantId(user.getTenantId());
        dto.setUserId(user.getUserId());
        FusionComponentUserDefinedDTO fusionComponentUserDefinedDTO = userDefinedService.queryFusionComponent(dto);
        return ResponseEntityWrapper.wrapperOk(fusionComponentUserDefinedDTO);
    }

    @PostMapping(value = {"/removeFusionComponent", "/open/removeFusionComponent"})
    ResponseEntity<?> removeFusionComponent(@RequestBody FusionComponentUserDefinedDTO dto,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        dto.checkParam();
        dto.setTenantId(user.getTenantId());
        dto.setUserId(user.getUserId());
        userDefinedService.removeFusionComponent(dto);
        return ResponseEntityWrapper.wrapperOk();
    }

}
