/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web;

import cn.hutool.json.JSONUtil;
import com.digiwin.athena.atdm.config.ThreadPoolDetailInfo;
import com.digiwin.athena.atdm.config.ThreadPoolMonitor;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/atdm/env"})
public class ThreadPoolController {
    @Autowired
    private ExecutorService executorService;
    @Resource
    private ServerProperties serverProperties;

    @GetMapping(value={"/getThreadPoolListInfo"})
    private List<ThreadPoolDetailInfo> getThreadPoolListInfo() {
        ArrayList<ThreadPoolDetailInfo> detailInfoList = new ArrayList<ThreadPoolDetailInfo>();
        ThreadPoolDetailInfo threadPoolDetailInfo = this.threadPoolInfo((ThreadPoolMonitor)this.executorService, "");
        detailInfoList.add(threadPoolDetailInfo);
        return detailInfoList;
    }

    @GetMapping(value={"/getServerProperties"})
    public String getServerProperties() {
        return JSONUtil.toJsonPrettyStr((Object)this.serverProperties);
    }

    private ThreadPoolDetailInfo threadPoolInfo(ThreadPoolMonitor threadPool, String threadPoolName) {
        BigDecimal activeCount = new BigDecimal(threadPool.getActiveCount());
        BigDecimal maximumPoolSize = new BigDecimal(threadPool.getMaximumPoolSize());
        BigDecimal result = activeCount.divide(maximumPoolSize, 2, 4);
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        int queueCapacity = threadPool.getQueueCapacity();
        return new ThreadPoolDetailInfo(threadPoolName, Integer.valueOf(threadPool.getPoolSize()), Integer.valueOf(threadPool.getCorePoolSize()), Integer.valueOf(threadPool.getLargestPoolSize()), Integer.valueOf(threadPool.getMaximumPoolSize()), threadPool.getCompletedTaskCount(), Integer.valueOf(threadPool.getActiveCount()), threadPool.getTaskCount(), threadPool.getKeepAliveTime(TimeUnit.MILLISECONDS), (int)result.doubleValue() * 100, Integer.valueOf(queueCapacity), Integer.valueOf(threadPool.getQueue().size()), threadPool.getTaskCount() == 0L ? 0L : threadPool.getTotalDiff() / threadPool.getTaskCount());
    }
}

